package com.agilex.healthcare.mobilehealthplatform.datalayer.event;

import com.agilex.healthcare.mobilehealthplatform.MockDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.mood.MoodEventDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvents;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class MoodEventDataLayerExcel implements MoodEventDataLayer {
	private static MockDataStorage<MoodEvents, MoodEvent> data = new MockDataStorage<MoodEvents, MoodEvent>() {
		@Override
		protected MoodEvents createDataCollection() {
			return new MoodEvents();
		}
	};

	private static final String COLUMN_PATIENTID = "PatientID";
	private static final String COLUMN_UNIQUEID = "UniqueID";
	private static final String COLUMN_DATE = "Date";
	private static final String COLUMN_VALUE = "Value";
	private static final String COLUMN_NOTE = "Note";
	private static final String domain = "Mood";

	@Override
	public MoodEvents getMoodEvents(String patientId) {
		if (!data.dataExists(patientId)) {
			DataElementDataStorage storage = DataElementDataStorage.getInstance();;
			DataElements dataElements = storage.getData(patientId, domain);
			data.setDataElements(createMoodEvents(dataElements));
		}
		return data.getDataForPatient(patientId);
	}

	@Override
	public MoodEvents getMoodEvents(String patientId, DateFilter filter) {
		MoodEvents moodEvents = getMoodEvents(patientId);
		if (NullChecker.isNullish(moodEvents)) {
			moodEvents = new MoodEvents();
		}
		MoodEvents filteredMoodEvents = DateFilterer.filterByDate(moodEvents, filter);
		return filteredMoodEvents;
	}

	@Override
	public MoodEvent getMoodEvent(String patientId, String eventId) {
		MoodEvent match = null;
		MoodEvents moodEvents = getMoodEvents(patientId);
		for (MoodEvent potentialMatch : moodEvents) {
			if (NullSafeStringComparer.areEqual(eventId, potentialMatch.getUniqueId())) {
				match = potentialMatch;
				break;
			}
		}
		return match;
	}

	@Override
	public MoodEvent saveMoodEvent(MoodEvent moodEvent) {
		setMoodEvent(moodEvent);
		return moodEvent;
	}

	private static synchronized void setMoodEvent(MoodEvent moodEvent) {
		data.setDataElement(moodEvent);
	}

	@Override
	public void deleteMoodEvent(MoodEvent moodEvent) {
		MoodEvent moodEventToRemove = null;
		MoodEvents patientMoodEvents = data.getDataForPatient(moodEvent.getPatientId());
		for(MoodEvent potentialMatch : patientMoodEvents) {
			if(NullSafeStringComparer.areEqual(potentialMatch.getUniqueId(), moodEvent.getUniqueId())) {
				moodEventToRemove = potentialMatch;
				break;
			}
		}
		if(moodEventToRemove != null) {
			patientMoodEvents.remove(moodEventToRemove);
		}
			
	}

	private MoodEvents createMoodEvents(DataElements dataElements) {
		MoodEvents moodEvents = new MoodEvents();
		for(DataElement dataElement : dataElements) {
			MoodEvent moodEvent = createMoodEvent(dataElement);
			moodEvents.add(moodEvent);
		}
		return moodEvents;
	}

	private MoodEvent createMoodEvent(DataElement dataElement) {
		MoodEvent moodEvent = new MoodEvent();
		moodEvent.setPatientId(dataElement.getValue(COLUMN_PATIENTID));
		moodEvent.setUniqueId(dataElement.getValue(COLUMN_UNIQUEID));
		moodEvent.setDate(dataElement.getValueAsDate(COLUMN_DATE));
		moodEvent.setValue(dataElement.getValue(COLUMN_VALUE));
		moodEvent.setNotes(dataElement.getValue(COLUMN_NOTE));
		return moodEvent;
	}
}
