package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import java.util.HashMap;
import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public class CalendarKeyDataLayerStub implements CalendarKeyDataLayer {

	private HashMap<String, String> cachedMap = new HashMap<String, String>();

	@Override
	public String fetchKeyByPatient(PatientIdentifier patientIdentifier) {
		String patientPublicKey = cachedMap.get(patientIdentifier.getUniqueId());
		if (patientPublicKey == null) {
			patientPublicKey = createKeyForPatient(patientIdentifier);
		}
		return patientPublicKey;
	}

	@Override
	public String fetchPatientByKey(String key) {
		if (key == null) {
			return null;
		}

		String patient = null;

		for (String potentialPatient : cachedMap.keySet()) {
			String potentialKey = cachedMap.get(potentialPatient);
			if (key.equals(potentialKey)) {
				patient = potentialPatient;
				break;
			}
		}

		return patient;
	}

	@Override
	public String createKeyForPatient(PatientIdentifier patientIdentifier) {
		String generatedKey = generateKeyToSave();
		cachedMap.put(patientIdentifier.getUniqueId(), generatedKey);

		return generatedKey;
	}

	@Override
	public void deleteKeyForPatient(PatientIdentifier patientIdentifier) {
		cachedMap.put(patientIdentifier.getUniqueId(), null);
	}

	private String generateKeyToSave() {
		return UUID.randomUUID().toString();
	}
}
