package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvents;
import com.agilex.healthcare.utility.DateHelper;

public class CalendarEventDataLayerStub implements CalendarEventDataLayer {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(CalendarEventDataLayerStub.class);
	Map<String, CalendarEvents> storage = new HashMap<String, CalendarEvents>();

	public CalendarEventDataLayerStub() {
		init("D123401");
	}

	private void init(String patientId) {
		CalendarEvents calendarEvents = new CalendarEvents();

		CalendarEvent calendarEvent = new CalendarEvent();
		calendarEvent.setUniqueId(UUID.randomUUID().toString());
		calendarEvent.setPatientId(patientId);
		calendarEvent.setNotes("Don't forget to fast tomorrow!");
		calendarEvent.setStartDate(DateHelper.getTomorrow());
		calendarEvent.setDuration(24 * 60);
		calendarEvent.setTitle("Don't Eat in the morning");
		calendarEvents.add(calendarEvent);

		calendarEvent = new CalendarEvent();
		calendarEvent.setUniqueId(UUID.randomUUID().toString());
		calendarEvent.setPatientId(patientId);
		calendarEvent.setNotes("Exercise 3 times per week");
		calendarEvent.setStartDate(DateHelper.getYesterday());
		calendarEvent.setDuration(24 * 60);
		calendarEvent.setTitle("Zoomba workout");
		calendarEvents.add(calendarEvent);

		calendarEvent = new CalendarEvent();
		calendarEvent.setUniqueId(UUID.randomUUID().toString());
		calendarEvent.setPatientId(patientId);
		calendarEvent.setNotes("Check your secure messsages");
		calendarEvent.setStartDate(DateHelper.parseDate("4/1/2012"));
		calendarEvent.setDuration(24 * 60);
		calendarEvent.setTitle("Secure Message Check");
		calendarEvents.add(calendarEvent);

		storage.put(patientId, calendarEvents);
	}

	@Override
	public CalendarEvents fetchCalendarEvents(String patientId) {
		CalendarEvents data = storage.get(patientId);
		logger.debug(String.format("fetching %s calendar events", data.size()));
		return data;
	}

	public CalendarEvent saveCalendarEvent(CalendarEvent calendarEvent) {
		calendarEvent.setUniqueId(UUID.randomUUID().toString());
		CalendarEvents calendarEvents = storage.get(calendarEvent.getPatientId());

		if (calendarEvents == null) {
			calendarEvents = new CalendarEvents();
			calendarEvents.add(calendarEvent);
			storage.put(calendarEvent.getPatientId(), calendarEvents);
		} else {
			calendarEvents.add(calendarEvent);
		}

		return calendarEvent;
	}
}
