package com.agilex.healthcare.mobilehealthplatform.datalayer.audit;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

import com.agilex.healthcare.mobilehealthplatform.domain.AuditLog;
import com.agilex.healthcare.mobilehealthplatform.domain.AuditLogs;

public class AuditLogDataLayerStub implements AuditLogDataLayer {

	public static Map<String, AuditLogs> storage = new ConcurrentHashMap<String, AuditLogs>();

	@Override
	public AuditLog saveAudit(AuditLog auditLog) {
		auditLog.setId(UUID.randomUUID().toString());
		AuditLogs auditLogs = storage.get(auditLog.getUserId());

		if(auditLogs == null) {
			auditLogs = new AuditLogs();
		} 
		
		auditLogs.add(auditLog);
		storage.put(auditLog.getUserId(), auditLogs);
		
		return auditLog;
	}
	
	@Override
	public AuditLog fetchAuditLog(String userId, String auditLogId) {
		AuditLogs auditLogsForUser = this.fetchAuditLogs(userId, null);
		
		AuditLog matchedLog = null;
		for(AuditLog auditLog : auditLogsForUser) {
			if(auditLog.getId().equals(auditLogId)) {
				matchedLog = auditLog;
			}
		}
		return matchedLog;
	}

	@Override
	public AuditLogs fetchAuditLogs(String userId, AuditLogFilter filter) {
		AuditLogs auditLogs = storage.get(userId);
		AuditLogs returnedAuditLogs = new AuditLogs();

		if(auditLogs == null) {
			return returnedAuditLogs;
		}
		
		for (AuditLog auditLog : auditLogs) {
			if(auditLog.getUserId().equals(userId)) {
				returnedAuditLogs.add(auditLog);
			}
		}

		return AuditLogFilterer.filter(returnedAuditLogs, filter);

	}
}
