package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.utility.DateHelper;

public class MentalHealthAppoinmentDataLayerMock implements MentalHealthAppointmentDataLayer {

	private ConcurrentHashMap<String, Appointments> cache = new ConcurrentHashMap<String, Appointments>();
	
	
	public MentalHealthAppoinmentDataLayerMock() {
		if(cache.isEmpty())
			init();
	}
	
	/**
	 * If you plan to change this data, keep in mind that this data is setup specifically to test PTSD application business
	 * rules.
	 */
	public void init(){
		Appointments appointments = new Appointments();
		
		// Gallow - Matches two cases "Has appointment in the next two weeks" "had one in the past 2 years"
		String patientId = "D123401";
		Appointment appointment = new Appointment();
		appointment.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
		appointment.setPatientIdentifier("EDIPI", patientId);
		appointment.setAppointmentStartDate(DateHelper.plusDays(new Date(), 5));
		appointment.setFacilityName("DC VAMC");
		appointment.setReasonForVisit("503");
		appointments.add(appointment);
		
		appointment = new Appointment();
		appointment.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
		appointment.setPatientIdentifier("EDIPI", patientId);
		appointment.setAppointmentStartDate(DateHelper.minusDays(new Date(), 5));
		appointment.setFacilityName("DC VAMC");
		appointment.setReasonForVisit("503");
		appointments.add(appointment);
		
		cache.put(patientId, appointments);
		
		// Aldie - Matches "has one in the next two weeks"
		appointments = new Appointments();
		patientId = "PATID26";
		
		appointment = new Appointment();
		appointment.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
		appointment.setPatientIdentifier("EDIPI", patientId);
		appointment.setAppointmentStartDate(DateHelper.plusDays(new Date(), 5));
		appointment.setFacilityName("DC VAMC");
		appointment.setReasonForVisit("503");
		appointments.add(appointment);
		
		cache.put(patientId, appointments);
		
		// Usability TestPatient - Matches "had one in the past 2 years"
		appointments = new Appointments();
		patientId = "PATID65";
		
		appointment = new Appointment();
		appointment.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
		appointment.setPatientIdentifier("EDIPI", patientId);
		appointment.setAppointmentStartDate(DateHelper.minusDays(new Date(), 5));
		appointment.setFacilityName("DC VAMC");
		appointment.setReasonForVisit("503");
		appointments.add(appointment);
		
		cache.put(patientId, appointments);
	}
	
	@Override
	public Appointments fetchMentalHealthAppointments(PatientIdentifier patientIdentifier, DateFilter filter) {
		Appointments appointments = cache.get(patientIdentifier.getUniqueId());
		
		if(appointments == null)
			return new Appointments();
		
		return DateFilterer.filterByDate(appointments, filter);
	}
}
