package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import java.util.HashSet;
import java.util.Set;

import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.DetailCode;

public class DetailCodeDataLayerExcel implements DetailCodeDataLayer{
	
	private static final String domain = "DetailCodes";
	private static final String COLUMN_DETAILCODE = "DetailCode";
	private static final String COLUMN_PROVIDER_MESSAGE = "ProviderMessage";
	private static final String COLUMN_VETERAN_MESSAGE = "VeteranMessage";

	private static Set<DetailCode> detailCodes;

	public DetailCodeDataLayerExcel() {
		synchronized (this) {
			if (detailCodes == null) {
				detailCodes = new HashSet<DetailCode>();
				DataElementDataStorage storage = DataElementDataStorage.getInstance();;
				DataElements dataElements = storage.getData(domain, domain);
				createDetailCodes(dataElements);
			}
		}
	}

	private void createDetailCodes(DataElements dataElements) {
		for (DataElement dataElement : dataElements) {
			detailCodes.add(createDetailCode(dataElement));
		}
	}
	
	private DetailCode createDetailCode(DataElement dataElement){
		DetailCode detailCode = new DetailCode();
		detailCode.setCode(dataElement.getValue(COLUMN_DETAILCODE));
		detailCode.setProviderMessage(dataElement.getValue(COLUMN_PROVIDER_MESSAGE));
		detailCode.setVeteranMessage(dataElement.getValue(COLUMN_VETERAN_MESSAGE));
		return detailCode;
	}

	@Override
	public Set<DetailCode> fetchDetailCodes() {
		return detailCodes;
	}

	@Override
	public DetailCode fetchDetailCodeByCode(String code) {
		DetailCode match = null;
		
		for (DetailCode detailCode : detailCodes) {
			if (detailCode.getCode().equals(code)) {
				match = detailCode;
			}
		}
		
		return match;
	}
}
