package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.MockDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class ClinicalNoteDataLayerExcel implements ClinicalNoteDataLayer {

	private static final String COLUMN_PATIENT_ID = "PatientId";
	private static final String COLUMN_VISIT_ID = "ClinicalVisitId";
	private static final String COLUMN_TEXT = "ClinicalNotes";
	private static final String domain = "ClinicNotes";
	
	private static MockDataStorage<ProviderNotes, ProviderNote> data = new MockDataStorage<ProviderNotes, ProviderNote>() {
		@Override
		protected ProviderNotes createDataCollection() {
			return new ProviderNotes();
		}
	};
	
	@Override
	public ProviderNote fetchClinicalNote(PatientIdentifier patientIdentifier, String outpatientVisitId) {
		ProviderNotes notes = fetchProviderNotes(patientIdentifier);
		
		ProviderNote match = null;
		for(ProviderNote note : notes) {
			if(NullSafeStringComparer.areEqualIgnoreCase(outpatientVisitId, note.getUniqueId())) {
				match = note;
				break;
			}
		}
		
		return match;
	} 

	private ProviderNotes fetchProviderNotes(PatientIdentifier patientIdentifier) {

		String patientId = patientIdentifier.getUniqueId();
		if(!data.dataExists(patientId)) {
			DataElementDataStorage storage = DataElementDataStorage.getInstance();
			DataElements dataElements = storage.getData(patientId, domain);
			data.setDataElements(createProviderNotes(dataElements));
		}
		
		return data.getDataForPatient(patientId);
	}
	
	private ProviderNotes createProviderNotes(DataElements dataElements) {
		ProviderNotes providerNotes = new ProviderNotes();
		
		for(DataElement dataElement : dataElements) {
			providerNotes.add(createProviderNote(dataElement));
		}
		
		return providerNotes;
	}
	
	private ProviderNote createProviderNote(DataElement dataElement) {
		ProviderNote providerNote = null;
		
		if(dataElement != null) {
			providerNote = new ProviderNote();
			providerNote.setPatientIdentifier("EDIPI", dataElement.getValue(COLUMN_PATIENT_ID));
			providerNote.setDataIdentifier("mock", dataElement.getValue(COLUMN_VISIT_ID));
			providerNote.setText(dataElement.getValue(COLUMN_TEXT));
		}
		
		return providerNote;
	}
	
}
