package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestInProcess;

public class AppointmentRequestInProcessDataLayerMock implements AppointmentRequestInProcessDataLayer{

	private static Map<String, AppointmentRequestInProcess> AppointmentsInProcess = new HashMap<String, AppointmentRequestInProcess>();
	private static Map<String, List<AppointmentRequestInProcess>> AppointmentsInProcessByUser = new HashMap<String, List<AppointmentRequestInProcess>>();

	
	@Override
	public AppointmentRequestInProcess fetchAppointmentRequestInProcessByAppointmentRequestId(String appointmentRequestId) {
		return AppointmentsInProcess.get(appointmentRequestId);
	}

	@Override
	public void deleteAppointmentRequestInProcessByUserId(String userId) {
		List<AppointmentRequestInProcess> inProcessRequestsByUser = AppointmentsInProcessByUser.get(userId);
		
		if (inProcessRequestsByUser != null) {
			for (AppointmentRequestInProcess appointmentRequestInProcess : inProcessRequestsByUser) {
				AppointmentsInProcess.remove(appointmentRequestInProcess.getAppointmentRequestId());
			}
		}
	}

	@Override
	public AppointmentRequestInProcess saveAppointmentRequestInProcess(AppointmentRequestInProcess appointmentRequestInProcess) {
		AppointmentsInProcess.put(appointmentRequestInProcess.getAppointmentRequestId(), appointmentRequestInProcess);

		List<AppointmentRequestInProcess> inProcessRequestsByUser = AppointmentsInProcessByUser.get(appointmentRequestInProcess.getUserId());
		if(inProcessRequestsByUser == null){
			inProcessRequestsByUser = new ArrayList<AppointmentRequestInProcess>();
			inProcessRequestsByUser.add(appointmentRequestInProcess);
			AppointmentsInProcessByUser.put(appointmentRequestInProcess.getUserId(), inProcessRequestsByUser);
		}else{
			inProcessRequestsByUser.add(appointmentRequestInProcess);
		}
		
		return appointmentRequestInProcess;
	}

	@Override
	public void deleteAppointmentRequestInProcessById(String appointmentRequestId) {
		AppointmentsInProcess.remove(appointmentRequestId);
	}

}
