package com.agilex.healthcare.mobilehealthplatform.datalayer.antibiogram;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.*;
import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.utility.DateHelper;

public class AntibiogramDataLayerExcel implements AntibiogramDataLayer {

	private static final String domain = "Organisms";
	private static final String COLUMN_ID = "Id";
	private static final String COLUMN_NAME = "Name";
	private static final String COLUMN_TYPE = "Type";
	private static final String COLUMN_SITE = "FacilitySiteCode";
	
	private static final String summary_domain = "AntibiogramSummary";
	private static final String SUMMARY_COLUMN_SITE = "FacilitySiteCode";
	private static final String SUMMARY_COLUMN_ORGANISM_ID = "OrganismId";
	private static final String SUMMARY_COLUMN_ANTIBIOTIC_NAME = "AntibioticName";
	private static final String SUMMARY_COLUMN_ANTIBIOTIC_ID = "AntibioticId";
	private static final String SUMMARY_COLUMN_TOTAL_TESTS = "TotalTests";
	private static final String SUMMARY_COLUMN_SENSITIVE_TESTS = "SensitiveTests";
	private static final String SUMMARY_COLUMN_MONTHS = "Months";
	
	
	private static Organisms organisms;
	private Map<String, AntibiogramSummaries> summaryMap;
	
	public AntibiogramDataLayerExcel() {
		
		synchronized(this) {
			DataElementDataStorage storage = DataElementDataStorage.getInstance();
			if(organisms == null) {
				organisms = new Organisms();
				DataElements dataElements = storage.getData(domain, domain);
				createOrganisms(dataElements);
			}
			if(summaryMap == null) {
				summaryMap = new ConcurrentHashMap<String, AntibiogramSummaries>();
				DataElements dataElements = storage.getData(domain, summary_domain);
				createAntibiogramSummaries(dataElements);
			}
		}
	}
	
	@Override
	public Organisms fetchOrganisms(String facilitySiteCode) {
		if(facilitySiteCode == null)
			throw new UnsupportedOperationException("Facility code is required! You have a bug");
		
		Organisms matches = new Organisms();
		for(Organism organism : organisms) {
			if(organism.getFacilitySiteCode().equals(facilitySiteCode)) {
				matches.add(organism);
			}
		}
		return matches;
	}
	
	private void createOrganisms(DataElements dataElements) {
		for(DataElement dataElement : dataElements) {
			organisms.add(createOrganism(dataElement));
		}
	}
	
	private Organism createOrganism(DataElement dataElement) {
		Organism organism = new Organism();
		
		organism.setId(dataElement.getValue(COLUMN_ID));
		organism.setName(dataElement.getValue(COLUMN_NAME));
		organism.setType(dataElement.getValue(COLUMN_TYPE));
		organism.setFacilitySiteCode(dataElement.getValue(COLUMN_SITE));
		
		return organism;
	}
	
//	@Override
//	public AntibiogramSummaries fetchSummaries(String facilitySiteCode, String organismId, DateFilter dateFilter) {
//		if(facilitySiteCode == null || organismId == null)
//			throw new UnsupportedOperationException("Facility Code and Organism id are required. Please also pass a date");
//		
//		Integer delta = DateHelper.calculateDeltaInMonth(dateFilter.getStartDate(), dateFilter.getEndDate());
//		AntibiogramSummaries antibiogramSummaries = summaryMap.get(delta.toString());
//		
//		AntibiogramSummaries filtered = new AntibiogramSummaries();
//		for(AntibiogramSummary summary : antibiogramSummaries) {
//			if(facilitySiteCode.equals(facilitySiteCode) && summary.getOrganismId().equals(organismId)) {
//				filtered.add(summary);
//			}
//		}
//		
//		return filtered;
//	}
	
	public void createAntibiogramSummaries(DataElements dataElements) {
		for(DataElement dataElement : dataElements) {
			AntibiogramSummary summary = new AntibiogramSummary();
			
			summary.setAntibioticId(dataElement.getValue(SUMMARY_COLUMN_ANTIBIOTIC_ID));
			summary.setAntibioticName(dataElement.getValue(SUMMARY_COLUMN_ANTIBIOTIC_NAME));
			summary.setFacilitySiteCode(dataElement.getValue(SUMMARY_COLUMN_SITE));
			summary.setTestCount(dataElement.getValue(SUMMARY_COLUMN_TOTAL_TESTS));
			summary.setSensitivityCount(dataElement.getValue(SUMMARY_COLUMN_SENSITIVE_TESTS));
			summary.setOrganismId(dataElement.getValue(SUMMARY_COLUMN_ORGANISM_ID));
			String months = dataElement.getValue(SUMMARY_COLUMN_MONTHS);
			
			addToSummaryMap(months, summary);
		}
	}

	private void addToSummaryMap(String months, AntibiogramSummary summary) {
		AntibiogramSummaries antibiogramSummaries = summaryMap.get(months);
		if(antibiogramSummaries == null || antibiogramSummaries.size() == 0) {
			antibiogramSummaries = new AntibiogramSummaries();
			antibiogramSummaries.add(summary);
			summaryMap.put(months, antibiogramSummaries);
		} else {
			antibiogramSummaries.add(summary);
		}
		
	}

	@Override
	public AntibiogramMatrix fetchMatrix(String facilitySiteCode,
			DateFilter dateFilter) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public OrganismGroups fetchOrganismGroups(String facilitySiteCode) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AntibiogramSummaries fetchSummaries(String facilitySiteCode, List<String> organismIds, DateFilter dateFilter) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<String> fetchOrganismsByGroup(String facilitySiteCode,
			String groupId) {
		// TODO Auto-generated method stub
		return null;
	}

}
