package com.agilex.healthcare.mobilehealthplatform.datalayer.allergy;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;

public class AllergyDataLayerMock implements AllergyDataLayer {
	private Allergies allergyStore;

	public AllergyDataLayerMock() {
		allergyStore = initializeMockAllergies();
	}

	private Allergies initializeMockAllergies() {
		Allergies allergies = new Allergies();
		Allergy allergy;

		allergy = new Allergy();
		allergy.setPatientId("D123401");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);

		allergy = new Allergy();
		allergy.setPatientId("D123401");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy = new Allergy();
		allergy.setPatientId("PATID26");
		allergy.setUniqueId("PATID26.1");
		allergy.setCategory("Drug Allergy");
		allergy.setReaction("Hypotension");
		allergy.setSubstance("Penicillin");
		allergy.setSeverity("Severe");
		allergies.add(allergy);
		
		allergy = new Allergy();
		allergy.setPatientId("PATID26");
		allergy.setUniqueId("PATID26.2");
		allergy.setCategory("Drug Allergy");
		allergy.setReaction("Hives");
		allergy.setSubstance("Shellfish");
		allergy.setSeverity("Severe");
		allergies.add(allergy);
		
		allergy = new Allergy();
		allergy.setPatientId("PATID56");
		allergy.setUniqueId("PATID56.1");
		allergy.setSubstance("No Known Allergies");
		allergies.add(allergy);
		
		allergy = new Allergy();
		allergy.setPatientId("PATID57");
		allergy.setUniqueId("PATID57.1");
		allergy.setCategory("Drug Allergy");
		allergy.setReaction("Hypotension");
		allergy.setSubstance("Penicillin");
		allergy.setSeverity("Severe");
		allergies.add(allergy);
		
		allergy = new Allergy();
		allergy.setPatientId("PATID57");
		allergy.setUniqueId("PATID57.2");
		allergy.setCategory("Drug Allergy");
		allergy.setReaction("Hives");
		allergy.setSubstance("Shellfish");
		allergy.setSeverity("Severe");
		allergies.add(allergy);
		
		allergy = new Allergy();
		allergy.setPatientId("PATID57");
		allergy.setUniqueId("PATID57.3");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("PATID57");
		allergy.setUniqueId("PATID57.4");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Morphine");
		allergies.add(allergy);
		
		allergy = new Allergy();
		allergy.setPatientId("PATID63");
		allergy.setUniqueId("PATID63.1");
		allergy.setCategory("Drug Allergy");
		allergy.setReaction("Hypotension");
		allergy.setSubstance("Penicillin");
		allergy.setSeverity("Severe");
		allergies.add(allergy);
		
		allergy = new Allergy();
		allergy.setPatientId("PATID31");
		allergy.setUniqueId("PATID31.1");
		allergy.setCategory("Drug Allergy");
		allergy.setReaction("Hypotension");
		allergy.setSubstance("Penicillin");
		allergy.setSeverity("Severe");
		allergies.add(allergy);
		
		allergy = new Allergy();
		allergy.setPatientId("PATID31");
		allergy.setUniqueId("PATID31.2");
		allergy.setReaction("Rash");
		allergy.setSubstance("Morphine");
		allergy.setSeverity("Severe");
		allergies.add(allergy);
		
		allergy = new Allergy();
		allergy.setPatientId("PATID31");
		allergy.setUniqueId("PATID31.3");
		allergy.setCategory("Drug Allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergies.add(allergy);
		
		allergy = new Allergy();
		allergy.setPatientId("PATID33");
		allergy.setUniqueId("PATID33.1");
		allergy.setCategory("Drug Allergy");
		allergy.setReaction("Hypotension");
		allergy.setSubstance("Penicillin");
		allergy.setSeverity("Severe");
		allergies.add(allergy);
		
		allergy.setPatientId("PATID65");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("PATID65");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy.setPatientId("PATID66");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("PATID66");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy.setPatientId("PATID67");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("PATID67");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy.setPatientId("PATID68");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("PATID68");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy.setPatientId("PATID69");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("PATID69");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy.setPatientId("PATID70");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("PATID70");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy.setPatientId("PATID71");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("PATID71");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy.setPatientId("PATID72");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("PATID72");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy.setPatientId("PATID73");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("PATID73");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy.setPatientId("PATID74");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("PATID74");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy.setPatientId("0010010010");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("0010010010");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		allergy.setPatientId("0010010011");
		allergy.setUniqueId("1");
		allergy.setCategory("Food allergy");
		allergy.setReaction("Anaphylaxis");
		allergy.setSubstance("Peanut");
		allergy.setSeverity("Severe");
		allergy.setNote("Carries Epipen");
		allergies.add(allergy);
        
		allergy = new Allergy();
		allergy.setPatientId("0010010011");
		allergy.setUniqueId("2");
		allergy.setCategory("Drug allergy");
		allergy.setReaction("Rash");
		allergy.setSubstance("Penicillin");
		allergies.add(allergy);
		
		for (Allergy a : allergies) {
			a.setSourceSystem("VA");
		}

		return allergies;
	}

	public Allergies getPatientAllergies(String patientId) {
		Allergies patientAllergies = new Allergies();
		for (Allergy allergy : allergyStore) {
			if (allergy.getPatientId().contentEquals(patientId))
				patientAllergies.add(allergy);
		}
		return patientAllergies;
	}
	
	public Allergies fetchAllergies(String patientId, DateFilter filter) {
		Allergies allergies = getPatientAllergies(patientId);
		return DateFilterer.filterByDate(allergies, filter);
	}

	@Override
	public Allergies fetchAllergies(PatientIdentifier patientIdentifier, DateFilter filter) {
		return fetchAllergies(patientIdentifier.getUniqueId(), filter);
	}

}
