package com.agilex.healthcare.mobilehealthplatform.datalayer.allergy;

import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;

public class AllergyDataLayerExcel implements AllergyDataLayer {

	private static final String COLUMN_PATIENTID = "PatientID";
	private static final String COLUMN_UNIQUEID = "UniqueID";
	private static final String COLUMN_SOURCESYS = "SourceSys";
	private static final String COLUMN_ACTIVE = "Active";
	private static final String COLUMN_CATEGORY = "Category";
	private static final String COLUMN_NOTE = "Note";
	private static final String COLUMN_ONSETDATE = "OnsetDate";
	private static final String COLUMN_REACTION = "Reaction";
	private static final String COLUMN_RESOLUTIONDATE = "ResolutionDate";
	private static final String COLUMN_SEVERITY = "Severity";
	private static final String COLUMN_SUBSTANCE = "Substance";
	private static final String domain = "Allergies";

	public Allergies getPatientAllergies(String patientId) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();
		DataElements dataElements = storage.getData(patientId, domain);
		return createAllergies(dataElements);
	}

	public Allergy getPatientAllergyLite(String patientId, String uniqueId) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();
		DataElement dataElement = storage.getData(patientId, domain, uniqueId, COLUMN_UNIQUEID);
		Allergy allergy = createAllergy(dataElement);
		return allergy;
	}
	
	private Allergies createAllergies(DataElements dataElements) {
		Allergies allergies = new Allergies();
		for (DataElement dataElement : dataElements) {
			Allergy m = createAllergy(dataElement);
			allergies.add(m);
		}
		return allergies;
	}

	private Allergy createAllergy(DataElement dataElement) {
		Allergy allergy = null;
		if (dataElement != null) {
			allergy = new Allergy();
			allergy.setPatientId(dataElement.getValue(COLUMN_PATIENTID));
			allergy.setUniqueId(dataElement.getValue(COLUMN_UNIQUEID));
			allergy.setSourceSystem(dataElement.getValue(COLUMN_SOURCESYS));
			allergy.setActive(dataElement.getValueAsBoolean(COLUMN_ACTIVE));
			allergy.setCategory(dataElement.getValue(COLUMN_CATEGORY));
			allergy.setNote(dataElement.getValue(COLUMN_NOTE));
			allergy.setOnsetDate(dataElement.getValueAsDate(COLUMN_ONSETDATE));
			allergy.setReaction(dataElement.getValue(COLUMN_REACTION));
			allergy.setResolutionDate(dataElement.getValueAsDate(COLUMN_RESOLUTIONDATE));
			allergy.setSeverity(dataElement.getValue(COLUMN_SEVERITY));
			allergy.setSubstance(dataElement.getValue(COLUMN_SUBSTANCE));
		}
		return allergy;
	}

	public Allergies fetchAllergies(String patientId, DateFilter filter) {
		Allergies allergies = getPatientAllergies(patientId);
		return DateFilterer.filterByDate(allergies, filter);
	}

	@Override
	public Allergies fetchAllergies(PatientIdentifier patientIdentifier, DateFilter filter) {
		return fetchAllergies(patientIdentifier.getUniqueId(), filter);
	}
}
