package com.agilex.healthcare.mobilehealthplatform.datalayer.admission;

import com.agilex.healthcare.mobilehealthplatform.MockDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;

public class DischargeNoteDataLayerExcel implements DischargeNoteDataLayer {
	
	private static final String COLUMN_PATIENT_ID = "PatientId";
	private static final String COLUMN_UNIQUE_ID = "UniqueId";
	private static final String COLUMN_TEXT = "DischargeSummary";
	private static final String COLUMN_ENTRY_DATE = "EntryDate";
	private static final String domain = "DischargeNotes";
	
	private static MockDataStorage<ProviderNotes, ProviderNote> data = new MockDataStorage<ProviderNotes, ProviderNote>() {
		@Override
		protected ProviderNotes createDataCollection() {
			return new ProviderNotes();
		}
	};

	@Override
	public ProviderNote fetchDischargeNote(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		ProviderNotes notes = fetchNotes(patientIdentifier, dateFilter);
		
		if(notes != null && notes.size() > 0)
			return notes.get(0);
		
		return null;
	}
	
	private ProviderNotes fetchNotes(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		
		String patientId = patientIdentifier.getUniqueId();
		if(!data.dataExists(patientId)) {
			DataElementDataStorage storage = DataElementDataStorage.getInstance();
			DataElements dataElements = storage.getData(patientId, domain);
			data.setDataElements(createDischargeNotes(dataElements));
		}
		
		ProviderNotes notes = data.getDataForPatient(patientId);
		return DateFilterer.filterByDate(notes, dateFilter);
	}

	private ProviderNotes createDischargeNotes(DataElements dataElements) {
		ProviderNotes notes = new ProviderNotes();
		
		for(DataElement dataElement : dataElements) {
			notes.add(createDischargeNote(dataElement));
		}
		
		return notes;
	}
	
	private ProviderNote createDischargeNote(DataElement dataElement) {
		ProviderNote providerNote = null;
		
		if(dataElement != null) {
			providerNote = new ProviderNote();
			providerNote.setPatientIdentifier("EDIPI", dataElement.getValue(COLUMN_PATIENT_ID));
			providerNote.setDataIdentifier("mock", dataElement.getValue(COLUMN_UNIQUE_ID));
			providerNote.setText(dataElement.getValue(COLUMN_TEXT));
			providerNote.setEntryDate(dataElement.getValueAsDate(COLUMN_ENTRY_DATE));
		}
		
		return providerNote;
	}

}
