package com.agilex.healthcare.mobilehealthplatform.datalayer.admission;

import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;

public class AdmissionDataLayerExcel implements AdmissionDataLayer {

	private static final String COLUMN_DISCHARGESUMMARY = "DischargeSummary";
	private static final String COLUMN_FACILITYNAME = "FacilityName";
	private static final String COLUMN_DISCHARGEDATE = "DischargeDate";
	private static final String COLUMN_ADMISSIONDATE = "AdmissionDate";
	private static final String COLUMN_UNIQUEID = "UniqueId";
	private static final String COLUMN_PATIENTID = "PatientId";
	private static final String COLUMN_ADMITTINGPROVIDER = "AdmittingProvider";
	private static final String domain = "Admissions";

	@Override
	public Admissions getAdmissions(String patientId, DateFilter filter, boolean shouldIncludeDetails) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();
		DataElements dataElements = storage.getData(patientId, domain);
		Admissions admissions = createAdmissions(dataElements, shouldIncludeDetails);
		Admissions filteredItems = DateFilterer.filterByDate(admissions, filter);
		return filteredItems;
	}

	private Admissions createAdmissions(DataElements dataElements, boolean includeDischargeSummary) {
		Admissions admissions = new Admissions();
		for (DataElement dataElement : dataElements)
			admissions.add(createAdmission(dataElement, includeDischargeSummary));
		return admissions;
	}

	private Admission createAdmission(DataElement dataElement, boolean includeDischargeSummary) {
		Admission admission = new Admission();
		admission.setUniqueId(dataElement.getValue(COLUMN_UNIQUEID));
		admission.setAdmissionDate(dataElement.getValueAsDate(COLUMN_ADMISSIONDATE));
		admission.setDischargeDate(dataElement.getValueAsDate(COLUMN_DISCHARGEDATE));
		admission.setFacilityName(dataElement.getValue(COLUMN_FACILITYNAME));
		admission.setPatientId(dataElement.getValue(COLUMN_PATIENTID));
		admission.setAdmittingProviderName(dataElement.getValue(COLUMN_ADMITTINGPROVIDER));

		if (includeDischargeSummary) {
			admission.setDischargeSummary(dataElement.getValue(COLUMN_DISCHARGESUMMARY));
		}

		return admission;
	}

	@Override
	public Admission getAdmission(String patientId, String uniqueId) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();;
		DataElement dataElement = storage.getData(patientId, domain, uniqueId, COLUMN_UNIQUEID);
		return createAdmission(dataElement, true);
	}

	@Override
	public Admissions fetchAdmissions(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		return getAdmissions(patientIdentifier.getUniqueId(), dateFilter, false);
	}

	@Override
	public Admission fetchAdmission(PatientIdentifier patientIdentifier, String admissionId) {
		return getAdmission(patientIdentifier.getUniqueId(), admissionId);
	}

}
