package com.agilex.healthcare.vamf.cdw.vitals;

import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalObservation;
import com.agilex.healthcare.mobilehealthplatform.domain.code.ObservationTypeCode;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.domain.code.VitalSectionCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigInteger;
import java.util.Date;

@Entity
@Table(name = "App.Vitals")
public class CdwVitalEntryPo {

    private BigInteger vitalId;
    private String patientIcn;
    private String vitalType;
    private Integer vitalTypeId;
    private Date dateTaken;
    private String result;
    private Integer facilityCode;
    private String location;

    public CdwVitalEntryPo() {}

    public CdwVitalEntryPo(BigInteger vitalId, String vitalType, Integer vitalTypeId, Date dateTaken, String result, Integer facilityCode, String location) {
        this.vitalId = vitalId;
        this.vitalType = vitalType;
        this.vitalTypeId = vitalTypeId;
        this.dateTaken = dateTaken;
        this.result = result;
        this.facilityCode = facilityCode;
        this.location = location;
    }

    @Id
    @Column(name = "VitalSignSID")
    public BigInteger getVitalId() {
        return vitalId;
    }

    public void setVitalId(BigInteger vitalId) {
        this.vitalId = vitalId;
    }

    @Column(name = "PatientICN")
    public String getPatientIcn() {
        return patientIcn;
    }

    public void setPatientIcn(String patientIcn) {
        this.patientIcn = patientIcn;
    }

    @Column(name = "VitalType")
    public String getVitalType() {
        return vitalType;
    }

    public void setVitalType(String vitalType) {
        this.vitalType = vitalType;
    }

    @Column(name = "VitalTypeSID")
    public Integer getVitalTypeId() {
        return vitalTypeId;
    }

    public void setVitalTypeId(Integer vitalTypeId) {
        this.vitalTypeId = vitalTypeId;
    }

    @Column(name = "VitalSignTakenDateTime")
    public Date getDateTaken() {
        return dateTaken;
    }

    public void setDateTaken(Date dateTaken) {
        this.dateTaken = dateTaken;
    }

    @Column(name = "Result")
    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Column(name = "Sta3n")
    public Integer getFacilityCode() {
        return facilityCode;
    }

    public void setFacilityCode(Integer facilityCode) {
        this.facilityCode = facilityCode;
    }

    @Column(name = "Location")
    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public VitalEntry createVitalEntry() {
        VitalEntry entry = new VitalEntry();
        VitalObservation observation = new VitalObservation();

        entry.setEntryDate(getDateTaken());
        entry.setId(getVitalId().toString()); // VitalSID should never be null
        entry.setSystemId(SourceSystemCode.CDW);
        entry.setPatientId(getPatientIcn());
        entry.setSection(getVitalType());
        observation.setValue(getResult());
        setVitalObservationValues(entry);

        return entry;
    }



    void setVitalObservationValues(VitalEntry vitalEntry) {

        if (VitalsCode.BLOOD_PRESSURE.equalsIgnoreCase(getVitalType())) {
            vitalEntry.setSection(VitalSectionCode.BloodPressure);
            setBloodPressureObservationValues(vitalEntry, getResult());
            return;
        }

        String type = getVitalType();
        VitalObservation vitalObservation = new VitalObservation();

        if (VitalsCode.PULSE.equalsIgnoreCase(type)) {
            vitalObservation.setType(ObservationTypeCode.HEART_BEAT);
            vitalObservation.setValueUnits("BPM");
            vitalEntry.setSection(VitalSectionCode.Pulse);
        } else if (VitalsCode.TEMPERATURE.equalsIgnoreCase(type)) {
            vitalObservation.setType(ObservationTypeCode.BODY_TEMPERATURE);
            vitalObservation.setValueUnits("F");
            vitalEntry.setSection(VitalSectionCode.Temperature);
        } else if (VitalsCode.HEIGHT.equalsIgnoreCase(type)) {
            vitalObservation.setType(ObservationTypeCode.HEIGHT);
            vitalObservation.setValueUnits("In");
            vitalEntry.setSection(VitalSectionCode.Height);
        } else if (VitalsCode.WEIGHT.equalsIgnoreCase(type)) {
            vitalObservation.setType(ObservationTypeCode.WEIGHT);
            vitalObservation.setValueUnits("Lb");
            vitalEntry.setSection(VitalSectionCode.Weight);
        } else if (VitalsCode.PAIN.equalsIgnoreCase(type)) {
            vitalObservation.setType(ObservationTypeCode.PAIN);
            vitalEntry.setSection(VitalSectionCode.Pain);
        } else if (VitalsCode.RESPIRATION.equalsIgnoreCase(type)) {
            vitalObservation.setType(ObservationTypeCode.RESPIRATION);
            vitalEntry.setSection(VitalSectionCode.Respiration);
        } else if (VitalsCode.PULSE_OXIMETRY.equalsIgnoreCase(type) || VitalsCode.PULSE_OXIMETRY_MISSPELLED.equalsIgnoreCase(type)) {
            vitalObservation.setType(ObservationTypeCode.PULSE_OXIMETRY);
            vitalObservation.setValueUnits("SpO2");
            vitalEntry.setSection(VitalSectionCode.PulseOximetry);
        } else {
            // logger.debug("Vital type from CDW was not translated properly");
        }

        vitalObservation.setVitalEntry(vitalEntry);
        vitalObservation.setValue(getResult());
        vitalEntry.addObservation(vitalObservation);
    }

    void setBloodPressureObservationValues(VitalEntry vitalEntry, String result) {
        String[] systolicDiastolic = result.split("/");

        if (systolicDiastolic.length == 2) {
            VitalObservation observation = new VitalObservation();
            observation.setType(ObservationTypeCode.INTRAVASCULAR_SYSTOLIC);
            observation.setValue(systolicDiastolic[0]);
            observation.setValueUnits("mmHg");
            vitalEntry.addObservation(observation);

            observation = new VitalObservation();
            observation.setType(ObservationTypeCode.INTRAVASCULAR_DIASTOLIC);
            observation.setValue(systolicDiastolic[1]);
            observation.setValueUnits("mmHg");
            vitalEntry.addObservation(observation);
        }
    }
}
