package com.agilex.healthcare.vamf.cdw.surgery;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.agilex.healthcare.mobilehealthplatform.domain.Surgery;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.utility.DateHelper;

@Entity
@Table(name = "App.SurgeryReportsBySite")
public class CdwSurgeryPo {
    
    private String surgeryId;
    private String procedure;
    private String procedureDateNumeric;
    private String facility;
    
    @Id
    @Column(name="ID")
    public String getSurgeryId() {
        return surgeryId;
    }
    
    public void setSurgeryId(String surgeryId) {
        this.surgeryId = surgeryId;
    }
    
    @Column(name = "Principal_Procedure")
    public String getProcedure() {
        return procedure;
    }
    
    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }
    
    @Column(name = "dt")
    public String getProcedureDateNumeric() {
        return procedureDateNumeric;
    }
    
    public void setProcedureDateNumeric(String procedureDateNumeric) {
        this.procedureDateNumeric = procedureDateNumeric;
    }
    
    @Transient
    private Date getProcedureDate() {  	
        return DateHelper.parseVistaDate(getProcedureDateNumeric());
    }
    
    @Column(name = "station__no")
    public String getFacility() {
        return facility;
    }
    
    public void setFacility(String facility) {
        this.facility = facility;
    }
    
    public Surgery createSurgery() {
        Surgery surgery = new Surgery();
        
        surgery.setUniqueId(getSurgeryId());
        surgery.setSystemId(SourceSystemCode.CDW);
        surgery.setFacility(getFacility());
        surgery.setProcedure(procedure);
        surgery.setProcedureDate(getProcedureDate());       
        return surgery;
    }
       
}
