package com.agilex.healthcare.vamf.cdw.surgery;

import java.util.Date;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.springframework.stereotype.Repository;

import com.agilex.healthcare.mobilehealthplatform.datalayer.surgery.SurgeryDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgeries;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgery;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.NullSafeStringComparer;
import com.agilex.healthcare.utility.PatientIdentityHelper;

@Repository
public class CdwSurgeryDataLayer implements SurgeryDataLayer {
    
    @PersistenceContext(unitName="cdwPersistenceUnit")
    protected EntityManager entityManager;
    
    private static final String queryString = "{call App.SurgeryReportsBySite(:station, :patientId)}";
      
    @Deprecated
    @Override
    public Surgeries getPatientSurgeries(String patientId, DateFilter dateFilter) {
        throw new UnsupportedOperationException();
    }
    
    private Surgeries filter(Surgeries surgeries, DateFilter filter) {
        return DateFilterer.filterByDate(surgeries, filter);
    }
    
    @Override
    public Surgeries fetchSurgeries(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
        Query query = this.entityManager.createNativeQuery(queryString, CdwSurgeryPo.class);
        query.setParameter("patientId", patientIdentifier.getUniqueId());
        query.setParameter("station", patientIdentifier.getAssigningAuthority());
        List<CdwSurgeryPo> cdwSurgeries = (List<CdwSurgeryPo>)query.getResultList();
        Surgeries surgeries = createSurgeries(cdwSurgeries);
        return filter(surgeries, dateFilter);
        
    }
    
    @Override
    public Surgery fetchSurgery(PatientIdentifier patientIdentifier, String surgeryId) {
        Surgeries surgeries = fetchSurgeries(patientIdentifier, DateFilterFactory.createEmptyFilter());
        
        Surgery match = null;
        for(Surgery surgery : surgeries) {
            if(NullSafeStringComparer.areEqualIgnoreCase(surgery.getUniqueId(), surgeryId)) {
                match = surgery;
                break;
            }
        }
        
        return match;
    }
    
    Surgeries createSurgeries(List<CdwSurgeryPo> cdwSurgeries) {
        Surgeries surgeries = new Surgeries();
        if(NullChecker.isNotNullish(cdwSurgeries)) {
            for(CdwSurgeryPo po : cdwSurgeries) {
                surgeries.add(po.createSurgery());
            }
        }
        
        return surgeries;
    }
    
}