package com.agilex.healthcare.vamf.cdw.radiology;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResult;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;

@Entity
@Table(name = "App.RadiologyReportsBySite")
public class CdwRadiologyPo {
    
    private String radiologyId;
    private String facility;
    private String text;
    private String impression;
    private String title;
    private Date timestamp;
    
    @Id
    @Column(name="ID")
    public String getRadiologyId() {
        return radiologyId;
    }
    
    public void setRadiologyId(String radiologyId) {
        this.radiologyId = radiologyId;
    }   
    
    @Column(name="reporttextwp")
    public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	@Column(name="impressiontextwp")
	public String getImpression() {
		return impression;
	}

	public void setImpression(String impression) {
		this.impression = impression;
	}

	@Column(name="procedure102") //???
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Column(name="dt")
	public Date getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(Date timestamp) {
		this.timestamp = timestamp;
	}

	@Column(name = "station__no")
    public String getFacility() {
        return facility;
    }
    
    public void setFacility(String facility) {
        this.facility = facility;
    }
    
    public RadiologyResult createRadiologyResult() {
    	RadiologyResult result = new RadiologyResult();
        
    	result.setSystemId(SourceSystemCode.CDW);   	
    	result.setTestShortName(getTitle());
		result.setUniqueId(getRadiologyId());
		result.setTestId(getRadiologyId());
		result.setReport("REPORT:\n "+ getText() + "\n\nIMPRESSION:\n "+ getImpression());
		result.setTestName(getTitle());
		result.setSourceSystem(getFacility());
		result.setFacilityName(getFacility());
		result.setResultedDate(getTimestamp());
        return result;
    }
       
}
