package com.agilex.healthcare.vamf.cdw.radiology;

import java.util.Date;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.springframework.stereotype.Repository;

import com.agilex.healthcare.mobilehealthplatform.datalayer.radiology.RadiologyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResult;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResults;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.PatientIdentityHelper;

@Repository
public class CdwRadiologyDataLayer implements RadiologyDataLayer {
    
    @PersistenceContext(unitName="cdwPersistenceUnit")
    protected EntityManager entityManager;
    
    private static final String queryString = "{call App.RadiologyReportsBySite(:station, :fromDate, :toDate, :patientId)}";
        
    @Override
    public RadiologyResults getResults(PatientIdentifier patientIdentifier, DateFilter dateFilter){
        Query query = this.entityManager.createNativeQuery(queryString, CdwRadiologyPo.class);
        query.setParameter("patientId", patientIdentifier.getUniqueId());
        query.setParameter("station", patientIdentifier.getAssigningAuthority());
        query.setParameter("fromDate", startDateOrDefault(dateFilter));
        query.setParameter("toDate", endDateOrDefault(dateFilter));
        List<CdwRadiologyPo> cdwRadiologies = query.getResultList();
        RadiologyResults radiologyResults = createRadiologyResults(cdwRadiologies);
        return radiologyResults;
    }
    
    @Override
    public RadiologyResult fetchResult(PatientIdentifier patientIdentifier, String resultId){
    	RadiologyResults results = getResults(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		RadiologyResult search = null;
		for(RadiologyResult current : results) {
			if(current.getUniqueId().equals(resultId)) {
				search = current;
			}
		}
		
		return search;
    }
  
    RadiologyResults createRadiologyResults(List<CdwRadiologyPo> cdwRadiologies) {
    	RadiologyResults radiologies = new RadiologyResults();
        if(NullChecker.isNotNullish(cdwRadiologies)) {
            for(CdwRadiologyPo po : cdwRadiologies) {
            	radiologies.add(po.createRadiologyResult());
            }
        }
        
        return radiologies;
    }
    
    Date startDateOrDefault(DateFilter filter) {
        if(filter == null || filter.getStartDate() == null)
        	return DateHelper.parseDate("01/01/1990");
        return filter.getStartDate();
    }
    
    Date endDateOrDefault(DateFilter filter) {
        if(filter == null || filter.getEndDate() == null)
            return new Date();
        return filter.getEndDate();
    }
}