package com.agilex.healthcare.vamf.cdw.problems;

import java.math.BigInteger;
import java.util.Date;

import javax.persistence.*;

import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssigningAuthorityCode;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;

@Entity
@Table(name = "App.ProblemList")
public class ProblemPo {

	private static final String CDW_ACTIVE_FLAG = "Y";

	private BigInteger id;
	private String description;
	private Date onsetDate;
	private Date resolutionDate;
	private Date lastUpdatedDate;
	private String comments;
	private String patientIcn;
	private String active;
	private String sourceSystem;
	private String priority;

	@Id
	@Column(name = "ProblemListSID")
	public BigInteger getId() {
		return id;
	}

	public void setId(BigInteger id) {
		this.id = id;
	}

	@Column(name = "ProviderNarrative")
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Column(name = "EnteredDate")
	public Date getOnsetDate() {
		return onsetDate;
	}

	public void setOnsetDate(Date onsetDate) {
		this.onsetDate = onsetDate;
	}

	@Column(name = "ResolvedDate")
	public Date getResolutionDate() {
		return resolutionDate;
	}

	public void setResolutionDate(Date resolutionDate) {
		this.resolutionDate = resolutionDate;
	}
	
	
	@Column(name="LastModifiedDate")
	public Date getLastUpdatedDate() {
		return lastUpdatedDate;
	}

	public void setLastUpdatedDate(Date lastUpdatedDate) {
		this.lastUpdatedDate = lastUpdatedDate;
	}

	@Column(name="ICDDescription")
	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	@Column(name="PatientICN")
	public String getPatientIcn() {
		return patientIcn;
	}

	public void setPatientIcn(String patientIcn) {
		this.patientIcn = patientIcn;
	}

    @Transient
	public boolean isActive() {
		return CDW_ACTIVE_FLAG.equals(active);
	}

	@Column(name = "ActiveFlag")
	public String getActive() {
		return active;
	}

	public void setActive(String active) {
		this.active = active;
	}

	@Column(name = "Facility")
	public String getSourceSystem() {
		return sourceSystem;
	}

	public void setSourceSystem(String sourceSystem) {
		this.sourceSystem = sourceSystem;
	}

	@Column(name = "Priority")
	public String getPriority() {
		return priority;
	}

	public void setPriority(String priority) {
		this.priority = priority;
	}

	public Problem createProblem() {
		DataIdentifier dataIdentifer = new DataIdentifier(SourceSystemCode.CDW, getId().toString());
		PatientIdentifier patientIdentifier = new PatientIdentifier(AssigningAuthorityCode.ICN, getPatientIcn());
		return new Problem(dataIdentifer, patientIdentifier, getDescription(), 
				getOnsetDate(), getResolutionDate(), getLastUpdatedDate(), 
				getComments(), isActive(), getPriority(), getSourceSystem());
	}

}

