package com.agilex.healthcare.vamf.cdw.medication;

import java.math.BigInteger;
import java.util.Date;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.utility.NullChecker;

@Entity
@Table(name = "App.MedicationsList")
public class CdwMedicationPo {
    
	private BigInteger id;
	private String name;
	private String rxNum;
	private String quantity;
	private Date expirationDate;
	private Date issueDate;
    private String startDate;
    private String orderId;
    private String status;
    private Integer refills;
    private Date lastFillDate;
    private Integer facility;
    private String sig;
    private String detail;
    private Integer daysSupply;
       
    @Id
    @Column(name="RxOutpatSID")    
    public BigInteger getId() {
		return id;
	}

	public void setId(BigInteger id) {
		this.id = id;
	}

	@Column(name="LocalDrugNameWithDose")    
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name="RxNumber")
	public String getRxNum() {
		return rxNum;
	}

	public void setRxNum(String rxNum) {
		this.rxNum = rxNum;
	}

	@Column(name="Qty")
	public String getQuantity() {
		return quantity;
	}

	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	@Column(name="ExpirationDate")
	public Date getExpirationDate() {
		return expirationDate;
	}

	public void setExpirationDate(Date expirationDate) {
		this.expirationDate = expirationDate;
	}

	@Column(name="IssueDate")
	public Date getIssueDate() {
		return issueDate;
	}

	public void setIssueDate(Date issueDate) {
		this.issueDate = issueDate;
	}
	
	@Transient
	public String getStartDate() {
		return startDate;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	@Column(name="RxOutpatIEN")
	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	@Column(name="RxStatus")
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	@Column(name="MaxRefills")
	public Integer getRefills() {
		return refills;
	}

	public void setRefills(Integer refills) {
		this.refills = refills;
	}

	@Column(name="LastFillDate")
	public Date getLastFillDate() {
		return lastFillDate;
	}

	public void setLastFillDate(Date lastFillDate) {
		this.lastFillDate = lastFillDate;
	}

	@Column(name="Sig")
	public String getSig() {
		return sig;
	}

	public void setSig(String sig) {
		this.sig = sig;
	}

	@Column(name="PatientInstructions")
	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

	@Column(name="DaysSupply")
	public Integer getDaysSupply() {
		return daysSupply;
	}

	public void setDaysSupply(Integer daysSupply) {
		this.daysSupply = daysSupply;
	}

	@Column(name = "Sta3n")
    public Integer getFacility() {
        return facility;
    }
	
	public void setFacility(Integer facility) {
        this.facility = facility;
    }
    
    public Medication createMedicationResult() {
    	Medication medication = new Medication();
        
    	medication.setSystemId(SourceSystemCode.CDW); 
    	
    	medication.setId(getMedicationId());
		medication.setUniqueId(getMedicationId());
		medication.setOrderNumber(getOrderId());
		medication.setDrugName(getName());
		medication.setPrescriptionId(getRxNum());
		medication.setMedicationDetail(getDetail());
		medication.setStatus(getStatus());
		medication.setQuantity(getQuantity());
		medication.setSig(getSig());
		if(getRefills() != null)
			medication.setRefills(getRefills().toString());
		if( getDaysSupply() != null)
			medication.setDaysSupply(getDaysSupply().toString());
		
		medication.setTotalRefills(getRefills());
		
		medication.setLastFilledDate(getLastFillDate());
		medication.setStartDate(getIssueDate());
		medication.setExpiredDate(getExpirationDate());
		medication.setMedicationSource(MedicationFilter.OUTPATIENT);
		
		if( getFacility() != null)
			medication.setSourceSystem(getFacility().toString());

        return medication;
    }
    
    @Transient
    private String getMedicationId() {
		String medicationId = this.getId().toString(); //handle null
		if(NullChecker.isNullish(medicationId))
			medicationId = this.getOrderId();
		if(NullChecker.isNullish(medicationId))
			medicationId = UUID.randomUUID().toString();
		
		return medicationId;
		
	}
}
