package com.agilex.healthcare.vamf.cdw.medication;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.springframework.stereotype.Repository;

import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.PatientIdentityHelper;

@Repository
public class CdwMedicationDataLayer implements MedicationDataLayer {
    
    @PersistenceContext(unitName="cdwPersistenceUnit")
    protected EntityManager entityManager;
    
    private static final String queryString = "{call APP.MedicationsList(:patientIcn)}";
        
    @Override
	public Medications getMedications(PatientIdentifier patientIdentifier, MedicationFilter medicationFilter) {
    	PatientIdentifier truncatedIcn = truncateICN(patientIdentifier);
        Query query = this.entityManager.createNativeQuery(queryString, CdwMedicationPo.class);
        query.setParameter("patientIcn", truncatedIcn.getUniqueId());
        List<CdwMedicationPo> cdwMedications = query.getResultList();
        Medications medications = createMedicationResults(cdwMedications);
        return medications;
	}

	@Override
	public Medications getMedications(PatientIdentifier patientIdentifier, boolean activeOnly) {
		//Medications medications = dataLayer.getMedications(alterForCdw(patientIdentifier), activeOnly);
		//return setIdentifiers(medications, patientIdentifier, SourceSystemCode.CDW);
		return null;
	}

	@Override
	public Medication getMedicationLite(PatientIdentifier patientIdentifier, String orderNumber) {
		//Medication medication = dataLayer.getMedicationLite(alterForCdw(patientIdentifier), orderNumber);
		//return setIdentifiers(medication, patientIdentifier, SourceSystemCode.CDW);
		return null;
	}

	@Override
	public Medication getMedicationDetail(PatientIdentifier patientIdentifier, String medicationId) {
		//Medication medication = dataLayer.getSingleMedication(alterForCdw(patientIdentifier), medicationId);
		//return setIdentifiers(medication, patientIdentifier, SourceSystemCode.CDW);
		return null;
	}
	
    
	Medications createMedicationResults(List<CdwMedicationPo> cdwMedications) {
		Medications medications = new Medications();
        if(NullChecker.isNotNullish(cdwMedications)) {
            for(CdwMedicationPo po : cdwMedications) {
            	medications.add(po.createMedicationResult());
            }
        }
        
        return medications;
    }
    
    PatientIdentifier truncateICN(PatientIdentifier patientIdentifier) {
        PatientIdentityHelper helper = new PatientIdentityHelper();
        return helper.truncateICN(patientIdentifier);
    }
    
}