package com.agilex.healthcare.vamf.cdw.facilities;

import java.math.BigInteger;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.domain.Facility;

@Entity
@Table(name = "App.AllInstitutions")
public class FacilityPo {
	
	private BigInteger id;
	private String name;
	private String type;
	private String facilityCode;
	private String state;
	private String city;
	private String address;
	private String parentSiteCode;
	
	public FacilityPo() {}
	
	public FacilityPo(String name, String type, String facilityCode, String parentSiteCode, 
			String state, String address) {
		
		this.name = name;
		this.type = type;
		this.facilityCode = facilityCode;
		this.parentSiteCode = parentSiteCode;
		this.state = state;
		this.address = address;
	}
	
	@Id
	@Column(name = "InstitutionSID")
	public BigInteger getId() {
		return id;
	}
	
	public void setId(BigInteger id) {
		this.id = id;
	}
	
	@Column(name = "InstitutionName")
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	@Column(name = "FacilityType")
	public String getType() {
		return type;
	}
	
	public void setType(String type) {
		this.type = type;
	}
	
	@Column(name = "InstitutionCode")
	public String getFacilityCode() {
		return facilityCode;
	}
	
	public void setFacilityCode(String facilityCode) {
		this.facilityCode = facilityCode;
	}
	
	@Column(name="StateAbbrev")
	public String getState() {
		return state;
	}
	
	public void setState(String state) {
		this.state = state;
	}
	
	@Column(name = "City")
	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	@Column(name = "StreetAddress1")
	public String getAddress() {
		return address;
	}
	
	public void setAddress(String address) {
		this.address = address;
	}
	
	@Column(name = "Sta3n")
	public String getParentSiteCode() {
		return parentSiteCode;
	}
	
	public void setParentSiteCode(String parentSiteCode) {
		this.parentSiteCode = parentSiteCode;
	}
	
	public Facility createFacility() {
		return new Facility(getName(), getType(), getFacilityCode(), 
				getState(), getCity(), getAddress(), getParentSiteCode());
		
	}
	

}
