package com.agilex.healthcare.vamf.cdw.facilities;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

import org.springframework.stereotype.Repository;

import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityFilterer;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;

@Repository
public class CdwFacilityDataLayer implements FacilityDataLayer {
	
	@PersistenceContext(unitName="cdwPersistenceUnit")
    protected EntityManager entityManager;
	
	private static final String FACILITY_QUERY = "FROM FacilityPo";

	@Override
	public Facilities fetchFacilities(FacilityFilter filter) {
		final TypedQuery<FacilityPo> query = this.entityManager.createQuery(FACILITY_QUERY, FacilityPo.class);
		List<FacilityPo> facilityPos = query.getResultList();
		
		Facilities facilities = toFacilities(facilityPos);
		return filter(facilities, filter);
	}
	
	Facilities toFacilities(List<FacilityPo> facilityPos) {
		Facilities facilities = new Facilities();
		
		for(FacilityPo facilityPo : facilityPos) {
			facilities.add(facilityPo.createFacility());
		}
		
		return facilities;
	}
	
	Facilities filter(Facilities facilities, FacilityFilter filter) {
		FacilityFilterer filterer = new FacilityFilterer(); 

		return filterer.filter(facilities, filter);
	}

}
