package com.agilex.healthcare.vamf.cdw.chemlabs;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.utility.NullChecker;

import javax.persistence.*;

import java.math.BigInteger;
import java.util.Date;

@Entity
@Table(name = "App.ChemLabs")
public class CdwChemLabResultPo {

    private BigInteger labResultId;
    private BigInteger labTestId;
    private String testName;
    private String testType;
    private String location;
    private String patientIcn;
    private String result;
    private String referenceHigh;
    private String referenceLow;
    private String abnormal;
    private Date completionDate;
    private String units;
    private String loinc;
    private String facility;

    @Id
    @Column(name="LabChemSID")
    public BigInteger getLabResultId() {
        return labResultId;
    }

    public void setLabResultId(BigInteger labResultId) {
        this.labResultId = labResultId;
    }

    @Column(name="LabChemTestSID")
    public BigInteger getLabTestId() {
        return labTestId;
    }

    @Transient
    private String getLabTestIdAsString() {
        if(labTestId != null) return labTestId.toString();
        else return null;
    }

    public void setLabTestId(BigInteger labTestId) {
        this.labTestId = labTestId;
    }

    @Column(name="LabChemTestName")
    public String getTestName() {
        return testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    @Column(name="LabTestType")
    public String getTestType() {
        return testType;
    }

    public void setTestType(String testType) {
        this.testType = testType;
    }

    @Column(name="Sta3n")
    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Column(name = "PatientICN")
    public String getPatientIcn() {
        return patientIcn;
    }

    public void setPatientIcn(String patientIcn) {
        this.patientIcn = patientIcn;
    }

    @Column(name = "LabChemResultValue")
    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Column(name = "RefHigh")
    public String getReferenceHigh() {
        return referenceHigh;
    }

    public void setReferenceHigh(String referenceHigh) {
        this.referenceHigh = referenceHigh;
    }

    @Column(name = "RefLow")
    public String getReferenceLow() {
        return referenceLow;
    }

    public void setReferenceLow(String referenceLow) {
        this.referenceLow = referenceLow;
    }

    @Column(name = "Abnormal")
    public String getAbnormal() {
        return abnormal;
    }

    public void setAbnormal(String abnormal) {
        this.abnormal = abnormal;
    }

    @Column(name = "LabChemCompleteDateTime")
    public Date getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    @Column(name = "Units")
    public String getUnits() {
        return units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    @Column(name = "LOINC")
    public String getLoinc() {
        return loinc;
    }

    public void setLoinc(String loinc) {
        this.loinc = loinc;
    }

    @Column(name = "Facility")
    public String getFacility() {
        return facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public LabResult createLabResult() {
        LabResult labResult = new LabResult();

        labResult.setUniqueId(getLabResultId().toString());
        labResult.setSystemId(SourceSystemCode.CDW);
        labResult.setValue(getResult());
        labResult.setResultedDate(getCompletionDate());
        labResult.setTestId(getLabTestIdAsString());
        labResult.setTestname(getTestName());
        labResult.setValueUnits(getUnits());
        labResult.setIndicator(getAbnormal());
        labResult.setReferenceHigh(getReferenceHigh());
        labResult.setReferenceLow(getReferenceLow());
        labResult.setLoinc(getLoinc());
        labResult.setSourceSystem(alterFacilityName(getFacility()));

        return labResult;
    }

    boolean determineAbnormality(String abnormal) {
        if(NullChecker.isNullish(abnormal)) return false;
        else return true;
    }

    public static String alterFacilityName(String siteName) {
        if(NullChecker.isNullish(siteName))
            return siteName;

        siteName = siteName.trim();
        if("(".equalsIgnoreCase(Character.toString(siteName.charAt(0)))) {
            return siteName.substring(6, siteName.length());
        }

        return siteName;
    }
}
