package com.agilex.healthcare.vamf.cdw.appointment;

import javax.persistence.*;

import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;

import java.util.Date;

@MappedSuperclass
public abstract class AppointmentPoBase {
	 
	@Id
	@Column(name = "AppointmentSID")
	private String id;

	@Column(name = "AppointmentDateTime")
	private Date appointmentStartDate;

	@Column(name = "InstitutionName")
	private String facilityName;

	@Column(name = "VisitSID")
	private String clinicVisitId; 

	@Column(name = "LocationName")
	private String clinicName;

	@Column(name = "PrimaryStopCode")
	private String reasonForVisit;

	@Column(name = "MedicalService")
	private String clinicType;
	
	@Transient
	private String status;

	public AppointmentPoBase() {}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public Date getAppointmentStartDate() {
		return appointmentStartDate;
	}

	public void setAppointmentStartDate(Date appointmentStartDate) {
		this.appointmentStartDate = appointmentStartDate;
	}

	public String getFacilityName() {
		return facilityName;
	}

	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}

	public String getClinicVisitId() {
		return clinicVisitId;
	}

	public void setClinicVisitId(String clinicVisitId) {
		this.clinicVisitId = clinicVisitId;
		if (clinicVisitId != null) {
			setStatus("kept");
		}
	}

	public String getClinicName() {
		return clinicName;
	}

	public void setClinicName(String clinicName) {
		this.clinicName = clinicName;
	}

	public String getReasonForVisit() {
		return reasonForVisit;
	}

	public void setReasonForVisit(String reasonForVisit) {
		this.reasonForVisit = reasonForVisit;
	}

	public String getClinicType() {
		return clinicType;
	}

	public void setClinicType(String clinicType) {
		this.clinicType = clinicType;
	}

	private String getStatus() {
		return status;
	}

	private void setStatus(String status) {
		this.status = status;
	}
	
	public Appointment translateToAppointment(){
		Appointment appt = new Appointment();
		appt.setUniqueId(this.getId());
		appt.setAppointmentStartDate(this.getAppointmentStartDate());
		appt.setClinicName(this.getClinicName());
		appt.setClinicType(this.getClinicType());
		appt.setClinicVisitId(this.getClinicVisitId());
		appt.setFacilityName(this.getFacilityName());
		appt.setReasonForVisit(this.getReasonForVisit());
		appt.setSourceSystem(this.getFacilityName());
		appt.setStatus(this.getStatus());
		return appt;
	}

}
