package com.agilex.healthcare.vamf.cdw.allergy;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

@Entity
@Table(name = "App.AllergyReportsBySite")
public class CdwAllergyPo {
      
    private String allergenId;
    private String allergenName;
    private String allergenType;
    private String reaction;
    private String timestamp;
    private String facility;

    
    @Id
    @Column(name="ID")    
    public String getAllergenId() {
		return allergenId;
	}

	public void setAllergenId(String allergenId) {
		this.allergenId = allergenId;
	}

	@Column(name="reactant")  
	public String getAllergenName() {
		return allergenName;
	}

	public void setAllergenName(String allergenName) {
		this.allergenName = allergenName;
	}

	@Column(name="allergy_type") 
	public String getAllergenType() {
		return allergenType;
	}

	public void setAllergenType(String allergenType) {
		this.allergenType = allergenType;
	}

	@Column(name="reaction")  
	public String getReaction() {
		return reaction;
	}

	public void setReaction(String reaction) {
		this.reaction = reaction;
	}

	@Column(name="dt")
	public String getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(String timestamp) {
		this.timestamp = timestamp;
	}

	@Column(name = "facility")
    public String getFacility() {
        return facility;
    }
	
	public void setFacility(String facility) {
        this.facility = facility;
    }
    
	 @Transient
	 private Date getOnSetDate() {  	
	     return DateHelper.parseVistaDate(getTimestamp());
	 }
	 
    public Allergy createAllergy() {
    	Allergy allergy = new Allergy();
        
    	allergy.setCategory(getAllergenType());
		allergy.setSubstance(getAllergenName());
		allergy.setUniqueId(getAllergenId());
		allergy.setReaction(getReaction());
		allergy.setOnsetDate(getOnSetDate());
		allergy.setSourceSystem(alterFacilityName(getFacility()));
		allergy.setReaction(getReaction());
		allergy.setSystemId(SourceSystemCode.CDW);
		
        return allergy;
    }
       
    private String alterFacilityName(String siteName) {
        if(NullChecker.isNullish(siteName))
            return siteName;

        siteName = siteName.trim();
        if("(".equalsIgnoreCase(Character.toString(siteName.charAt(0)))) {
            return siteName.substring(6, siteName.length());
        }

        return siteName;
    }
}
