package com.agilex.healthcare.vamf.cdw.allergy;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.springframework.stereotype.Repository;

import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.PatientIdentityHelper;

@Repository
public class CdwAllergyDataLayer implements AllergyDataLayer {
    
    @PersistenceContext(unitName="cdwPersistenceUnit")
    protected EntityManager entityManager;
    
    private static final String queryString = "{call App.AllergyReportsBySite(:station, :patientId)}";

    @Override
    public Allergies fetchAllergies(PatientIdentifier patientIdentifier, DateFilter filter){
        Query query = this.entityManager.createNativeQuery(queryString, CdwAllergyPo.class);
        query.setParameter("patientId", patientIdentifier.getUniqueId());
        query.setParameter("station", patientIdentifier.getAssigningAuthority());
        List<CdwAllergyPo> cdwAllergies = query.getResultList();
        Allergies allergies = createAllergies(cdwAllergies);
        return filter(allergies, filter);
    }
  
    Allergies createAllergies(List<CdwAllergyPo> cdwAllergies) {
    	Allergies allergies = new Allergies();
        if(NullChecker.isNotNullish(cdwAllergies)) {
            for(CdwAllergyPo po : cdwAllergies) {
            	allergies.add(po.createAllergy());
            }
        }
        
        return allergies;
    }
    
    private Allergies filter(Allergies allergies, DateFilter dateFilter) {
		return DateFilterer.filterByDate(allergies, dateFilter);
	}   
    
}