package com.agilex.healthcare.vamf.cdw.admissions;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.springframework.stereotype.Repository;

import com.agilex.healthcare.mobilehealthplatform.datalayer.admission.AdmissionDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Admission;
import com.agilex.healthcare.mobilehealthplatform.domain.Admissions;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.utility.NullSafeStringComparer;
import com.agilex.healthcare.utility.PatientIdentityHelper;

@Repository
public class CdwAdmissionsDataLayer implements AdmissionDataLayer {

    @PersistenceContext(unitName="cdwPersistenceUnit")
    protected EntityManager entityManager;

    public static final String GET_ADMISSIONS_FOR_A_PATIENT = "select * from App.Admissions where PatientICN = :patientICN";

	public CdwAdmissionsDataLayer() {
	}
	
    @Override
    public Admissions fetchAdmissions(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
        // CDW does not use the checksum for data queries
        PatientIdentifier truncatedIcn = truncateICN(patientIdentifier);	
        Query query = this.entityManager.createNativeQuery(GET_ADMISSIONS_FOR_A_PATIENT, AdmissionPo.class);
        query.setParameter("patientICN", truncatedIcn.getUniqueId());
        
        @SuppressWarnings("unchecked")
		List<AdmissionPo> results = query.getResultList();
        Admissions admissions = convertAdmissionPostoAdmissions(results);
        admissions = setDataIdentifier(admissions, SourceSystemCode.CDW);
        return admissions;
    }

	@Override
	public Admission fetchAdmission(PatientIdentifier patientIdentifier, String admissionId) {
		Admissions admissions = fetchAdmissions(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		Admission admission = null;
		for(Admission current : admissions) {
			if (NullSafeStringComparer.areEqualIgnoreCase(admissionId, current.getUniqueId())) {
				admission = current;
			}
		}
		
		return admission;
	}

    public Admissions convertAdmissionPostoAdmissions(List<AdmissionPo> results){
        Admissions admissions = new Admissions();
        if (results != null && results.size() > 0) {
            for (AdmissionPo admissionPo : results) {
                admissions.add(admissionPo.create());
            }
        }
        return admissions;
    }
    public Admissions setDataIdentifier(Admissions admissions, String systemId){
        Admissions modifiedAdmissions = new Admissions();
        if (admissions != null && admissions.size() > 0) {
            for (Admission admission: admissions) {
                admission.setDataIdentifier(new DataIdentifier(systemId, admission.getInpatientSID()));
                modifiedAdmissions.add(admission);
            }
        }
        return modifiedAdmissions;
    }

    PatientIdentifier truncateICN(PatientIdentifier patientIdentifier) {
        PatientIdentityHelper helper = new PatientIdentityHelper();
        return helper.truncateICN(patientIdentifier);
    }
    
	@Override
	@Deprecated
	public Admissions getAdmissions(String patientId, DateFilter filter,
			boolean shouldIncludeDetails) {
		
		throw new UnsupportedOperationException();
	}

	@Override
	@Deprecated
	public Admission getAdmission(String patientId, String admissionIdentifier) {
		
		throw new UnsupportedOperationException();
	}
}
