package com.agilex.healthcare.vamf.cdw.admissions;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.domain.Admission;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssigningAuthorityCode;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@Entity
@Table(name = "App.Admissions")
@XStreamAlias("Admission")
public class AdmissionPo implements Serializable {

	private static final long serialVersionUID = -5534581765575616574L;
	
	private String inPatientSID;
    private String patientICN;
    private Date admissionDate;
    private Date dischargeDate;
    private String facilityName;
    private String facilitySiteCode;


    @Id
    @Column(name = "InpatientSID")
    public String getInPatientSID() {
        return inPatientSID;
    }

    public void setInPatientSID(String inPatientSID) {
        this.inPatientSID = inPatientSID;
    }

    @Column(name = "PatientICN")
    public String getPatientICN() {
        return patientICN;
    }

    public void setPatientICN(String patientICN) {
        this.patientICN = patientICN;
    }

    @Column(name = "AdmitDateTime")
    public Date getAdmissionDate() {
        return admissionDate;
    }

    public void setAdmissionDate(Date admissionDate) {
        this.admissionDate = admissionDate;
    }

    @Column(name = "DischargeDateTime")
    public Date getDischargeDate() {
        return dischargeDate;
    }

    public void setDischargeDate(Date dischargeDate) {
        this.dischargeDate = dischargeDate;
    }

    @Column(name = "Facility")
    public String getFacilityName() {
        return facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    @Column(name = "Sta3n")
    public String getFacilitySiteCode() {
        return facilitySiteCode;
    }

    public void setFacilitySiteCode(String facilitySiteCode) {
        this.facilitySiteCode = facilitySiteCode;
    }

    public Admission create(){
        Admission admission = new Admission();
        admission.setPatientIdentifier(new PatientIdentifier(AssigningAuthorityCode.ICN, getPatientICN()));
        admission.setAdmissionDate(getAdmissionDate());
        admission.setDischargeDate(getDischargeDate());
        admission.setFacilityName(getFacilityName());
        admission.setFacilityCode(getFacilitySiteCode());
        admission.setInpatientSID(getInPatientSID());
        return admission;
    }
}
