package com.agilex.heatlhcare.vamf.cdw.vitals;

import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalEntryFilter;
import com.agilex.healthcare.vamf.cdw.vitals.CdwVitalsDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.heatlhcare.vamf.cdw.SpringBasedIntegrationRepo;
import com.agilex.healthcare.vamf.cdw.vitals.VitalsCode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.Ignore;

import javax.annotation.Resource;
import java.util.Date;

public class VitalDataLayerCdwIntTest extends SpringBasedIntegrationRepo {

    @Resource
    CdwVitalsDataLayer dataLayer;
    PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1011491687V123456");

    @Test
    public void validateResourceCreation() {
        Assert.assertNotNull(dataLayer);
    }

    @Ignore("TODO: ensure data consistency with MAE CDW")
    @Test
    public void validateRetrievalWithTestPatientWithoutFilter() {
        VitalEntries vitalEntries = dataLayer.fetchVitalEntries(patientIdentifier, null);
        System.out.println(vitalEntries.size());
        Assert.assertTrue(vitalEntries.size() > 0);
    }

    @Test
    public void validateFetchWithFilter() {
        VitalEntryFilter filter = new VitalEntryFilter(VitalsCode.TEMPERATURE, DateHelper.parseDate("01/01/2010"), new Date());

        VitalEntries vitalEntries = dataLayer.fetchVitalEntries(patientIdentifier, filter);
        Assert.assertTrue(vitalEntries.size() >= 0);
    }

}
