package com.agilex.heatlhcare.vamf.cdw.chemlabs;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.vamf.cdw.chemlabs.CdwChemistryLabDataLayer;
import com.agilex.heatlhcare.vamf.cdw.SpringBasedIntegrationRepo;
import org.junit.Assert;
import org.junit.Test;

import javax.annotation.Resource;

public class CdwChemistryLabIntTest extends SpringBasedIntegrationRepo {
    @Resource
    CdwChemistryLabDataLayer dataLayer;
    PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1011491687V123456"); // Ruben Moreno test patient

    @Test
    public void validateResourceCreation() {
        Assert.assertNotNull(dataLayer);
    }

    @Test
    public void validateRetrieveWithoutDateFilter() {
        LabResults labResults = dataLayer.getLabResults(patientIdentifier, null);

        Assert.assertNotNull(labResults);
        Assert.assertTrue(labResults.size() > 21);
    }

    @Test
    public void validateRetrieveWithDateFilter() {
        DateFilter dateFilter = DateFilterFactory.createFilterFromDate(DateHelper.parseDate("01/30/2011"),DateHelper.getToday());
        LabResults labResults = dataLayer.getLabResults(patientIdentifier, dateFilter);

        Assert.assertNotNull(labResults);
        Assert.assertEquals(154,labResults.size());
    }
}
