package com.agilex.heatlhcare.vamf.cdw.careteam;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProviders;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterImpl;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.vamf.cdw.careteam.CdwPatientCareTeamDataLayer;
import com.agilex.healthcare.vamf.cdw.chemlabs.CdwChemistryLabDataLayer;
import com.agilex.heatlhcare.vamf.cdw.SpringBasedIntegrationRepo;
import org.junit.Assert;
import org.junit.Test;
import org.junit.Ignore;
import javax.annotation.Resource;

@Ignore("TODO: ensure data consistency with MAE CDW")
public class CdwPatientCareTeamIntTest extends SpringBasedIntegrationRepo {
    @Resource
    CdwPatientCareTeamDataLayer       dataLayer;
    PatientIdentifier                 patientIdentifier = new PatientIdentifier("ICN", "1011491687V123456"); // Ruben Moreno test patient
    public static final String            SITE_CODE = "442";

    @Test
    public void validateResourceCreation() {
        Assert.assertNotNull(dataLayer);
    }


    @Test
    public void testFetchPrimaryCareProviders() {
        PatientProviders    providers = dataLayer.fetchPrimaryCareProviders(patientIdentifier, SITE_CODE);

        Assert.assertNotNull(providers);
        Assert.assertEquals(1, providers.size());
    }

    @Test
    public void testFetchMentalHealthProviders() {
        PatientProviders    providers = dataLayer.fetchMentalHealthProviders(patientIdentifier, SITE_CODE);

        Assert.assertNotNull(providers);
        Assert.assertEquals(1, providers.size());
    }

    @Test
    public void testFetchMentalHealthProvidersWithDateRange() {
        DateFilterImpl      filter = new DateFilterImpl();

        filter.setStartDate(DateHelper.parse("01/01/2013", "MM/dd/yyyy"));
        filter.setEndDate(DateHelper.parse("12/31/2013", "MM/dd/yyyy"));


        PatientProviders    providers = dataLayer.fetchMentalHealthProviders(patientIdentifier, filter, SITE_CODE);

        Assert.assertNotNull(providers);
        Assert.assertEquals(1, providers.size());
    }

}
