package com.agilex.heatlhcare.vamf.cdw.appointment;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.vamf.cdw.appointment.CdwAppointmentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentRequestFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.heatlhcare.vamf.cdw.SpringBasedIntegrationRepo;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

import javax.annotation.Resource;

@Ignore("Tests apply to patient from integration CDW for story CMPM-162")
public class AppointmentDataLayerCdwIntTest extends SpringBasedIntegrationRepo {

    @Resource
    CdwAppointmentDataLayer dataLayer;
    PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1011491687");
    
	
    @Test
    public void validateResourceCreation() {
        Assert.assertNotNull(dataLayer);
    }

    @Test
    public void fetchPatientAppointments() {
        Appointments appts = dataLayer.fetchAppointmentsByPatient(patientIdentifier, null);
        Assert.assertNotNull(appts);
        Assert.assertTrue( appts.size() > 0);
    }

    @Test
    public void fetchPatientAppointmentsByDate() {
    	AppointmentRequestFilter filter = new AppointmentRequestFilter();
		filter.setStartDate(DateHelper.parseDate("4/25/2001"));
		filter.setEndDate(DateHelper.parseDate("5/18/2002"));
		Appointments appts = dataLayer.fetchAppointmentsByPatient(patientIdentifier, filter);
		Assert.assertNotNull(appts);
        Assert.assertTrue( appts.size() > 3);
    }

    @Test
    public void fetchPatientMHAppointments() {
        Appointments appts = dataLayer.fetchMentalHealthAppointments(patientIdentifier, null);
        Assert.assertNotNull(appts);
        Assert.assertTrue( appts.size() > 0);
    }
    
    @Test
    public void fetchPatientMHAppointmentsByDate() {
    	AppointmentRequestFilter filter = new AppointmentRequestFilter();
		filter.setStartDate(DateHelper.parseDate("11/14/2011"));
		filter.setEndDate(DateHelper.endOfDay(DateHelper.parseDate("11/14/2011")));
		Appointments appts = dataLayer.fetchMentalHealthAppointments(patientIdentifier, filter);
		Assert.assertNotNull(appts);
        Assert.assertTrue( appts.size() == 1);
    }
}
