package com.agilex.healthcare.vamf.cdw.facilities;

import javax.annotation.Resource;

import junit.framework.Assert;

import org.junit.Test;
import org.junit.Ignore;

import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.heatlhcare.vamf.cdw.SpringBasedIntegrationRepo;

public class CdwFacilityIntTest extends SpringBasedIntegrationRepo {

	@Resource
	CdwFacilityDataLayer dataLayer = new CdwFacilityDataLayer();

	@Test
	public void validateRetrievalOfAll() {
		Facilities facilities = dataLayer.fetchFacilities(new FacilityFilter());

		Assert.assertTrue(facilities.size() >= 900);
	}

	@Test
	public void validateParentFacilityFilter() {
		FacilityFilter filter = new FacilityFilter();
		filter.setParentFacilitiesOnly(true);
		Facilities facilities = dataLayer.fetchFacilities(filter);

		Assert.assertTrue(facilities.size() > 100);
	}

  @Ignore("TODO: ensure data consistency with MAE CDW")
	@Test
	public void validateParentFacilitiesAndTermFilter() {
		FacilityFilter filter = new FacilityFilter();
		filter.setParentFacilitiesOnly(true);
		filter.setTerm("TEST");
		Facilities facilities = dataLayer.fetchFacilities(filter);

		Assert.assertEquals(2, facilities.size());
	}

}
