package com.agilex.healthcare.vamf.cdw.admissions;

import javax.annotation.Resource;

import org.junit.Assert;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Admission;
import com.agilex.healthcare.mobilehealthplatform.domain.Admissions;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.heatlhcare.vamf.cdw.SpringBasedIntegrationRepo;

public class CdwAdmissionsDataLayerTest extends SpringBasedIntegrationRepo {

	@Resource
	CdwAdmissionsDataLayer dataLayer = new CdwAdmissionsDataLayer();
	
	PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1001393625V123456");
	
	@Test
	public void validateBasicRetrieve() {
		Admissions admissions = dataLayer.fetchAdmissions(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		Assert.assertNotNull(admissions);
	}
	
	@Test
	public void validateFields() {
		Admissions admissions = dataLayer.fetchAdmissions(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		Admission admission = admissions.get(0);
		
		Assert.assertNotNull(admission.getPatientIdentifier());
		Assert.assertNotNull(admission.getPatientIdentifier().getUniqueId());
		Assert.assertNotNull(admission.getPatientIdentifier().getAssigningAuthority());
		Assert.assertNotNull(admission.getDataIdentifier());
		Assert.assertNotNull(admission.getDataIdentifier().getUniqueId());
		Assert.assertNotNull(admission.getDataIdentifier().getUniqueId());
		Assert.assertNotNull(admission.getAdmissionDate());
		Assert.assertNotNull(admission.getDischargeDate());
		Assert.assertNotNull(admission.getFacilityName());
	}
}
