USE [OIA_MobileHealth]
GO

/****** Object:  View [App].[ChemLabs]    Script Date: 8/6/2015 7:05:32 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF OBJECT_ID('[App].[ChemLabs]') IS NOT NULL
   BEGIN
       DROP VIEW
	       App.ChemLabs;
	END
GO


CREATE VIEW [App].[ChemLabs]    AS    
SELECT     PAT.PatientICN, PAT.TestPatientFlag, LC.Sta3n, LC.LabChemSID, LC.LabChemFieldNumber, LC.LabChemTestSID, CT.LabChemTestName, CT.LabTestType, LC.LabChemCompleteDateTime, 
           LOINC.LOINC, LC.Units, LC.RefHigh, LC.RefLow, LC.Abnormal, LC.LabChemResultValue, Facility    
FROM         CDWWork.Chem.PatientLabChem AS LC 
LEFT OUTER JOIN CDWWork.Patient.Patient AS PAT ON PAT.PatientSID = LC.PatientSID 
LEFT OUTER JOIN CDWWork.Dim.LOINC AS LOINC ON LOINC.LOINCSID = LC.LOINCSID 
LEFT OUTER JOIN CDWWork.Dim.LabChemTest AS CT ON CT.LabChemTestSID = LC.LabChemTestSID 
LEFT OUTER JOIN CDWWork.Dim.VistaSite AS ST ON CT.Sta3n = ST.Sta3n


GO


