package com.agilex.healthcare.hdr.appointment.model;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;

public class AppointmentMapperTest {
	// No time zone
	private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");

    @Test
    public void getAppointments() throws Exception {
        URL url = Resources.getResource("Appointments.xml");
        String appointmentsXML= Resources.toString(url, Charsets.UTF_8);
        AppointmentMapper mapper = new AppointmentMapper(appointmentsXML);

        Appointments appointments = mapper.map("123");

        assertEquals(36, appointments.size());

        Appointment appointment = appointments.get(0);

        assertEquals("123", appointment.getPatientId());
        assertEquals("3110830.13_544_2.98", appointment.getUniqueId());
        assertEquals("Tue Aug 30 13:00:00 2011", DATE_FORMAT.format(appointment.getAppointmentStartDate()));
        assertEquals("SCHEDULED/KEPT", appointment.getStatus());
        assertEquals("WJB G DENTAL HYGIENIST", appointment.getClinicName());
        assertEquals("800-293-8262", appointment.getClinicPhone());
        assertEquals("GREENVILLE SOC", appointment.getFacilityName());
        assertEquals("R", appointment.getStatusCode());
        
        appointment = appointments.get(28);
        assertNull(appointment.getFacilityName());
    }
}
