package com.agilex.healthcare.hdr.service;

import com.agilex.healthcare.hdr.appointment.model.*;
import com.agilex.healthcare.hdr.config.HDRConfig;
import com.agilex.soap.*;
import com.agilex.soap.exceptions.SoapServiceException;

import java.util.Date;

public class PathwaysService {
    private final HDRConfig config;

    public PathwaysService(HDRConfig config) {
        this.config = config;
    }
    public AppointmentMapper getAppointments(String patientId, Date startDate, Date endDate) {
        Service service = new Service(config.getEndPoint(), config.getConnectionTimeout(), config.getReadTimeout());

        GetAppointmentsRequest builder = new GetAppointmentsRequest();
        Message request = builder.build(patientId, startDate, endDate, config.getClientName());

        Message response = request.send(service);

        if (response.getBody().hasFault())
            throw new SoapServiceException(response.getBody().getFault().getFaultReason());

        return new AppointmentMapper(getAppointmentData(response));
    }

    private String getAppointmentData(Message response) {
        return response.getBody().getRootElement().getChild("out", "", null).getElementValue();
    }
}
