package com.agilex.healthcare.hdr.config;

import java.io.Serializable;

public class HDRConfig implements Serializable {
    private static final long serialVersionUID = 5120599193624994511L;

    private String endPoint;
    private int connectionTimeout;
    private int readTimeout;
    private String clientName;
    private String appointmentStatusCodes;

	public String getAppointmentStatusCodes() {
		return appointmentStatusCodes;
	}

	public void setAppointmentStatusCodes(String appointmentStatusCodes) {
		this.appointmentStatusCodes = appointmentStatusCodes;
	}

	public HDRConfig() {}

    public HDRConfig(String endPoint, int connectionTimeout, int readTimeout, String clientName) {
        this.endPoint = endPoint;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.clientName = clientName;
        this.appointmentStatusCodes = null;
    }

    public HDRConfig(String endPoint, int connectionTimeout, int readTimeout, String clientName, String appointmentStatusCodes) {
        this.endPoint = endPoint;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.clientName = clientName;
        this.appointmentStatusCodes = appointmentStatusCodes;
    }
 
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public String getEndPoint() {
        return endPoint;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getReadTimeout() {
        return readTimeout;
    }
    
    public String getClientName() {
		return clientName;
	}

	public void setClientName(String clientName) {
		this.clientName = clientName;
	}
    

    @Override
    public String toString() {
        return "Endpoint: " + endPoint + ", Connection Timeout: " + connectionTimeout + ", Read Timeout: " + readTimeout;
    }
}
