package com.agilex.healthcare.hdr.appointment.model;

import java.util.Date;

import org.joda.time.DateTime;

import com.agilex.soap.Element;
import com.agilex.soap.Message;

public class GetAppointmentsRequest {
    private static final String PREFIX = "pat";
    private static final String NAMESPACE = "http://repositories.domain.ext/pathways";

    //Inserting 3 values into string.  Better performance over DOM.  Simplier aka much less code.
    private static final String template = "<![CDATA[<?xml version=\"1.0\" encoding=\"UTF-8\"?><filter:filter vhimVersion=\"Vhim_4_00\" xmlns:filter=\"Filter\"><filterId>APPOINTMENTS_SINGLE_PATIENT_FILTER</filterId><clientName>%s</clientName><clientRequestInitiationTime>%s</clientRequestInitiationTime><patients><NationalId>%s</NationalId></patients><entryPointFilter queryName=\"Appointments-Standardized\"><domainEntryPoint>Appointment</domainEntryPoint>%s%s</entryPointFilter></filter:filter>]]>";

    private final Message message = new Message();

    public Message build(String patientId, Date startDate, Date endDate, String clientName) {
        message.addNamespace(PREFIX, NAMESPACE);

        Element root = message.getBody().addChild("readData", PREFIX, NAMESPACE);

        root.addChild("in0").addElementValue("AppointmentsRead1");
        root.addChild("in1").addElementValue(createFilter(patientId, startDate, endDate, clientName));
        root.addChild("in2").addElementValue("APPOINTMENTS_SINGLE_PATIENT_FILTER");
        root.addChild("in3").addElementValue(clientName);

        return message;
    }

    private String createFilter(String patientId, Date startDate, Date endDate, String clientName) {
        return String.format(template, clientName, new DateTime().toString(), patientId,
                             startDateFilter(startDate), endDateFilter(endDate));
    }

    private String startDateFilter(Date startDate) {
        if (startDate != null)
            return   "<startDate>" + new DateTime(startDate).toString("yyyy-MM-dd") + "</startDate>";
        else
            return "";
    }

    private String endDateFilter(Date endDate) {
        if (endDate != null)
            return   "<endDate>" + new DateTime(endDate).toString("yyyy-MM-dd") + "</endDate>";
        else
            return "";
    }
}
