package com.agilex.healthcare.hdr.appointment.datalayer;

import com.agilex.healthcare.hdr.appointment.model.AppointmentMapper;
import com.agilex.healthcare.hdr.config.HDRConfig;
import com.agilex.healthcare.hdr.service.PathwaysService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.PatientIdentityHelper;
import com.agilex.system.health.SmokeTest;
import com.agilex.system.health.SmokeTestStatus;

public class AppointmentRepository implements AppointmentDataLayer, SmokeTest {

    private final HDRConfig config;

    public AppointmentRepository(HDRConfig config) {
        this.config = config;
    }

    @Override
    public Appointments getProviderAppointments(String providerId, DateFilter filter) {
        throw new UnsupportedOperationException("getProviderAppointments is not supported.  Patient Id is required to retrieve appointments.");
    }

    @Override
    public Appointments getClinicAppointments(String clinicId, DateFilter filter) {
        throw new UnsupportedOperationException("getClinicAppointments is not supported.  Patient Id is required to retrieve appointments.");
    }

    @Override
    public Appointments fetchAppointmentsByPatient(PatientIdentifier patientIdentifier, DateFilter filter) {
        return fetchAppointmentsByPatient(patientIdentifier, filter, false);
    }

    @Override
    public Appointments fetchAppointmentsByPatient(PatientIdentifier patientIdentifier, DateFilter filter, boolean shouldIncludeDetails) {
        PathwaysService service = new PathwaysService(config);
        
        // the call must be made with a truncated ICN identifier
        PatientIdentifier altered = alterPatientIdentifier(patientIdentifier);
        AppointmentMapper mapper = service.getAppointments(altered.getUniqueId(), filter.getStartDate(), filter.getEndDate());

        // return the mapped Appointments with the original identifier
        Appointments appointments = mapper.map(patientIdentifier.getUniqueId());
        
        if(NullChecker.isNotNullish(config.getAppointmentStatusCodes())){
        	String[] statusCodes = config.getAppointmentStatusCodes().split(",");
        	return appointments.filterByStatusCodes(statusCodes);
        }else{
        	return appointments;
        }
    }

    @Override
    public Appointment fetchAppointment(PatientIdentifier patientIdentifier, String appointmentId) {
            Appointments appointments = fetchAppointmentsByPatient(patientIdentifier, DateFilterFactory.createEmptyFilter());

            for (Appointment appointment : appointments) {
                if (appointmentId.equals(appointment.getUniqueId()))
                    return appointment;
            }
        return null;
    }
    
    private PatientIdentifier alterPatientIdentifier(PatientIdentifier patientIdentifier) {
    	PatientIdentityHelper helper = new PatientIdentityHelper();
    	return helper.truncateICN(patientIdentifier);
    }

    @Override
    public SmokeTestStatus run() {
        SmokeTestStatus status = new SmokeTestStatus();

        try {
            PatientIdentifier patientIdentifier = new PatientIdentifier("mock-aa", "PATID40");
            fetchAppointmentsByPatient(patientIdentifier, DateFilterFactory.createEmptyFilter());
            status.setSuccess(true);
        } catch (Exception e) {
            status.setException(e);
        }

        status.setConfiguration(config.toString());

        return status;
    }
}
