package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.adr.model.DemographicMapper;
import com.agilex.healthcare.adr.service.SupplementalDemographicsService;
import com.agilex.healthcare.mobilehealthplatform.adr.AdrConfiguration;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.PatientIdentityHelper;
import com.agilex.system.health.SmokeTest;
import com.agilex.system.health.SmokeTestStatus;

public class PatientSupplementalDemographicsDataLayerAdr implements PatientSupplementalDemographicsDataLayer, SmokeTest {

	private AdrConfiguration adrConfiguration;

	public PatientSupplementalDemographicsDataLayerAdr() {}

	public PatientSupplementalDemographicsDataLayerAdr(AdrConfiguration adrConfiguration) {
		this.adrConfiguration = adrConfiguration;
	}

	@Override
	public PatientDemographics fetchDemographics(PatientIdentifier patientIdentifier) {
		PatientIdentifier paddedIdentifier = padIdentifier(patientIdentifier.getUniqueId());
		
		SupplementalDemographicsService service = new SupplementalDemographicsService();
		DemographicMapper demographicMapper = service.getDemographics(paddedIdentifier.getUniqueId(), adrConfiguration);

		PatientDemographics demographics = demographicMapper.map();
		
		if (demographics == null){
			demographics = new PatientDemographics();
		}

		demographics.setPatientIdentifier("ICN", patientIdentifier.getUniqueId());
		
		return demographics;
	}
	
	private PatientIdentifier padIdentifier(String patientId) {
		PatientIdentityHelper helper = new PatientIdentityHelper();
		return helper.padIcn(new PatientIdentifier("ICN", patientId));
	}

    @Override
    public SmokeTestStatus run() {
        SmokeTestStatus status = new SmokeTestStatus();

        try {
            fetchDemographics(new PatientIdentifier("", "0000000001"));
            status.setSuccess(true);
        } catch (Exception e) {
            status.setException(e);
        }

        status.setConfiguration(adrConfiguration.toString());

        return status;

    }

	@Override
	public NextOfKin fetchPatientNextOfKin(PatientIdentifier patientIdentifier) {
		PatientDemographics patientDemographics = fetchDemographics(patientIdentifier);
		return patientDemographics.getNextOfKin();
	}

	@Override
	public PatientDemographics fetchPatientContactInformation(PatientIdentifier patientIdentifier) {
		return fetchDemographics(patientIdentifier);
	}
}
