package com.agilex.healthcare.mobilehealthplatform.adr;

import java.io.Serializable;

public class AdrConfiguration implements Serializable {

	private static final long serialVersionUID = 4952020448716252105L;
	
	private static final String DEFAULT_REQUEST_NAME = "mobileHealthRequest";

	private String wsdlUrl;
	private String endPointUrl;
	private String requestName = DEFAULT_REQUEST_NAME;
	private String username;
	private String password;
    private int connectionTimeout;
    private int readTimeout;

	public AdrConfiguration() {
	}

	@Deprecated // Need to correct some mode configurations
	public AdrConfiguration(String wsdlUrl, String endPointUrl, String username, String password, int connectionTimeout, int readTimeout) {
		this.wsdlUrl = wsdlUrl;
		this.endPointUrl = endPointUrl;
		this.username = username;
		this.password = password;
        this.setConnectionTimeout(connectionTimeout);
        this.setReadTimeout(readTimeout);
	}
	
	public AdrConfiguration(String wsdlUrl, String endPointUrl, String requestName, String username, String password, int connectionTimeout, int readTimeout) {
		this.wsdlUrl = wsdlUrl;
		this.endPointUrl = endPointUrl;
		this.requestName = requestName;
		this.username = username;
		this.password = password;
        this.setConnectionTimeout(connectionTimeout);
        this.setReadTimeout(readTimeout);
	}

	public String getWsdlUrl() {
		return wsdlUrl;
	}

	public void setWsdlUrl(String wsdlUrl) {
		this.wsdlUrl = wsdlUrl;
	}

	public String getEndPointUrl() {
		return endPointUrl;
	}

	public void setEndPointUrl(String endPointUrl) {
		this.endPointUrl = endPointUrl;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}
	
	public String getRequestName() {
		return requestName;
	}

	public void setRequestName(String requestName) {
		this.requestName = requestName;
	}

    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder("wsdlUrl: ");
		builder.append(this.wsdlUrl);
		builder.append("\nendPointUrl: ");
		builder.append(this.endPointUrl);
		builder.append("\nusername: ");
		builder.append(this.username);
		builder.append("\npassword: ");
		builder.append("********");
		return builder.toString();
	}
}
