package com.agilex.healthcare.mobilehealthplatform.adr;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSupplementalDemographicsDataLayerAdr;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.system.health.SmokeTest;
import com.agilex.system.health.SmokeTestStatus;

public class AdrSoapLearningTest {
	AdrConfiguration adrConfiguration;
	PatientSupplementalDemographicsDataLayerAdr dataLayer;

	@Before
	public void setUp() {
		  Properties p = new Properties();
		  String ADR_WSDL_URL = "";
	    String ADR_ENDPOINT_URL = "";

	    try {
        // note: properties file is loading from the classpath; if the int tests are being run through gradle,
        // this file can be placed at the root + /intTest/spring/properties/va-veteran-dev.int.properties
	    	InputStream is = ClassLoader.getSystemResourceAsStream("spring/properties/va-veteran-dev.int.properties");
	    	p.load(is);
	    	ADR_WSDL_URL = p.getProperty("adr.wsdlUrl");
	    	ADR_ENDPOINT_URL = p.getProperty("adr.endPointUrl");
	    } catch (IOException e) {
	    	ADR_WSDL_URL = ADR_ENDPOINT_URL = "https://vaww.esrdev30.aac.domain:8430/esr-ws/spring-ws/getEESummary/";
	    }



		// https://vaww.esrdev30.aac.domain:8430/esr-ws/spring-ws/getEESummary/
		// -- don't have specific access to this
		// https://vaww.server1234.aac.domain:8443/esr-ws/spring-ws/getEESummary/
		adrConfiguration = new AdrConfiguration(ADR_WSDL_URL, ADR_ENDPOINT_URL, "mobileHealthRequest", "mobileHealthAcct", "mhaReq$29", 5000, 30000);

		dataLayer = new PatientSupplementalDemographicsDataLayerAdr(adrConfiguration);
	}

	@Test
	public void validateConnectivity() {
		PatientDemographics supplementalDemographics = dataLayer.fetchDemographics(new PatientIdentifier("ICN", "1011215990V998459"));

		// Fairly generic to allow us to change the ICN without causing the test
		// to fail.
		assertNotNull(supplementalDemographics);
		assertNotNull(supplementalDemographics.getAddresses());
		assertTrue(supplementalDemographics.getAddresses().size() >= 1);
		assertNotNull(supplementalDemographics.getPhoneNumbers());
		assertTrue(supplementalDemographics.getPhoneNumbers().size() >= 1);
		assertNotNull(supplementalDemographics.getNextOfKin());
	}

	@Test
	public void smokeTestSuccess() {
		SmokeTest test = dataLayer;
		SmokeTestStatus status = test.run();

		assertTrue(status.isSuccess());
	}

	@Test
	public void smokeTestFailure() {
		adrConfiguration = new AdrConfiguration("https://www.google.com/esr-ws/spring-ws/eeSummary.wsdl", "https://www.google.com:8443/esr-ws/spring-ws/getEESummary/", "invalidRequest", "mobileHealthAcct", "mhaReq$29", 3000, 10000);
		SmokeTest test = new PatientSupplementalDemographicsDataLayerAdr(adrConfiguration);
		SmokeTestStatus status = test.run();

		assertFalse(status.isSuccess());
		assertEquals("java.net.SocketTimeoutException", status.getExceptionType());
	}

}
