#!/bin/sh
# ###########################################################################
# Script generated by HP Fortify SCA Scan Wizard (c) HP Fortify 2011
# Created on 2014/03/26 09:19:59
# ###########################################################################
# Generated for the following languages:
# 	HTML
# 	Java
# 	Javascript
# 	XML
# ###########################################################################
# DEBUG - if set to true, runs SCA in debug mode
# SOURCEANALYZER - the name of the SCA executable
# BUILDID - the SCA build id
# LAUNCHERSWITCHES - the launcher settings that are used to invoke SCA
# ARGFILE - the name of the argument file that's extracted and passed to SCA
# MEMORY - the memory settings for SCA
# OLDFILENUMBER - this defines the file which contains the number of files within the project, it is automatically generated
# FILENOMAXDIFF - this is the percentage of difference between the number of files which will trigger a warning by the script
# ###########################################################################

DEBUG=false
SOURCEANALYZER=sourceanalyzer
FPR="FortifyADRLib.fpr"
BUILDID="ADRLib"
ARGFILE="ADR-HA-Fortify.sh.args"
MEMORY="-Xmx1200M -Xms600M -Xss24M "

LAUNCHERSWITCHES=""
OLDFILENUMBER=ADR-HA-Fortify.sh.fileno
FILENOMAXDIFF=10

PROJECTROOT0="/Users/mortonr/code/vamf/iha-r3/Product/Production/ADRLib"
if [ ! -d "$PROJECTROOT0" ]; then
   echo  "ERROR: This script is being run on a different machine than it was"
   echo  "       generated on or the targeted project has been moved. This script is "
   echo  "       configured to locate files at"
   echo  "          $PROJECTROOT0"
   echo  "       Please modify the \$PROJECTROOT0 variable found"
   echo  "       at the top of this script to point to the corresponding directory"
   echo  "       located on this machine."
   exit
fi

if [ $DEBUG = true ]; then export LAUNCHERSWITCHES="-debug $LAUNCHERSWITCHES"; fi
echo Extracting Arguments File


grep "# ARGS" $0 | grep -v grep | cut -d" " -f3- | sed -e s#PROJECTROOT0_MARKER#"$PROJECTROOT0"#g   > $ARGFILE

# ###########################################################################
echo Cleaning previous scan artifacts
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID -clean 
if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
# ###########################################################################
echo Translating files
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID @$ARGFILE
if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
# ###########################################################################
echo Testing Difference between Translations
FILENUMBER=`$SOURCEANALYZER -b $BUILDID -show-files | wc -l`

if [ ! -f $OLDFILENUMBER ]; then
	echo It appears to be the first time running this script, setting $OLDFILENUMBER to $FILENUMBER
	echo $FILENUMBER > $OLDFILENUMBER
else
	OLDFILENO=`cat $OLDFILENUMBER`
	DIFF=`expr $OLDFILENO "*" $FILENOMAXDIFF`
	DIFF=`expr $DIFF /  100`

	MAX=`expr $OLDFILENO + $DIFF`
	MIN=`expr $OLDFILENO - $DIFF`

	if [ $FILENUMBER -lt $MIN ] ; then SHOWWARNING=true; fi
	if [ $FILENUMBER -gt $MAX ] ; then SHOWWARNING=true; fi

	if [ $SHOWWARNING == true ] ; then
		echo "WARNING: The number of files has changed by over $FILENOMAXDIFF%, it is recommended"
		echo "         that this script is regenerated with the ScanWizard"
	fi

	echo $MAX $MIN $DIFF
fi;

# ###########################################################################
echo Starting scan
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID -scan -f $FPR
if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
# ###########################################################################
echo Finished
# ARGS "-cp"
# ARGS "PROJECTROOT0_MARKER/build/classes/main/com/agilex/healthcare/adr/model/code/DemographicCode.class:PROJECTROOT0_MARKER/build/classes/main/com/agilex/healthcare/adr/model/DemographicMapper.class:PROJECTROOT0_MARKER/build/classes/main/com/agilex/healthcare/adr/model/GetEESummaryRequest.class:PROJECTROOT0_MARKER/build/classes/main/com/agilex/healthcare/adr/service/SupplementalDemographicsService.class:PROJECTROOT0_MARKER/build/classes/main/com/agilex/healthcare/mobilehealthplatform/adr/AdrConfiguration.class"
# ARGS "-cp"
# ARGS "PROJECTROOT0_MARKER/build/classes/main/com/agilex/healthcare/mobilehealthplatform/datalayer/patient/PatientSupplementalDemographicsDataLayerAdr.class:PROJECTROOT0_MARKER/build/classes/test/com/agilex/healthcare/adr/model/DemographicMapperTest.class:PROJECTROOT0_MARKER/build/libs/ADRLib-3.2.2-SNAPSHOT.jar"
# ARGS "-source"
# ARGS "1.6"
# ARGS "PROJECTROOT0_MARKER"
