#!/bin/sh

runTest()
{

	pTestName=$1
	pURL=$2
	pUser=$3
	pPass=$4
	pMediaType=$5
	pConcurrentCalls=$6
	pNumberOfSecs=$7

	BASE_OUTPUT_DIR="./perftest-results/vav/concurrency-tests/${pTestName}"
    pTestName=${pTestName}-${pConcurrentCalls}
	mkdir -p ${BASE_OUTPUT_DIR}
	
	OUT_FILE="${BASE_OUTPUT_DIR}/${pTestName}.out"
	DETAIL_OUT_FILE="${BASE_OUTPUT_DIR}/${pTestName}.dat"
	echo "running test ${pTestName}. CONCURRENT:${pConcurrentCalls}; SECS: ${pNumberOfSecs}; URL:${pURL}"
	ab -A ${pUser}:${pPass} -r -t ${pNumberOfSecs} -H "Accept: ${pMediaType}" -c ${pConcurrentCalls} -g $DETAIL_OUT_FILE $URL > $OUT_FILE ${pURL}
	echo "complete running test ${pTestName}. NUMBER=${pNumberOfCalls}; CONCURRENT:${pConcurrentCalls}; URL:${pURL}"
	sleep 30	
}

USER="ovid1234"
PASS="qwer1234%"
MEDIA="Application/XML"
NUMBEROFSECONDS="120"

echo "begin test suite"

#runTest "prod-c-allergies" "http://IPADDRESS   :8081/MobileHealthPlatformWeb/rest/patient/default/67995/allergies" ${USER} ${PASS} ${MEDIA} 1 ${NUMBEROFSECONDS}
#runTest "prod-c-allergies" "http://IPADDRESS   :8081/MobileHealthPlatformWeb/rest/patient/default/67995/allergies" ${USER} ${PASS} ${MEDIA} 10 ${NUMBEROFSECONDS}
#runTest "prod-c-allergies" "http://IPADDRESS   :8081/MobileHealthPlatformWeb/rest/patient/default/67995/allergies" ${USER} ${PASS} ${MEDIA} 20 ${NUMBEROFSECONDS}
runTest "prod-c-allergies" "http://IPADDRESS   :8081/MobileHealthPlatformWeb/rest/patient/default/67995/allergies" ${USER} ${PASS} ${MEDIA} 40 ${NUMBEROFSECONDS}

echo "complete with test suite"
