#!/bin/sh

runTest()
{
	pTestName=$1
	pURL=$2
	pUser=$3
	pPass=$4
	pMediaType=$5
	pConcurrentCalls=$6
	pNumberOfCalls=$7

	BASE_OUTPUT_DIR="./perftest-results/ov/${pTestName}"
	mkdir -p ${BASE_OUTPUT_DIR}
	
	OUT_FILE="${BASE_OUTPUT_DIR}/${pTestName}.out"
	DETAIL_OUT_FILE="${BASE_OUTPUT_DIR}/${pTestName}.dat"
	echo "running test ${pTestName}. NUMBER=${pNumberOfCalls}; CONCURRENT:${pConcurrentCalls}; URL:${pURL}"
	ab -A ${pUser}:${pPass} -n ${pNumberOfCalls} -H "Accept: ${pMediaType}" -c ${pConcurrentCalls} -g $DETAIL_OUT_FILE $URL > $OUT_FILE ${pURL}
	echo "complete running test ${pTestName}. NUMBER=${pNumberOfCalls}; CONCURRENT:${pConcurrentCalls}; URL:${pURL}"
	sleep 1	
}

USER="OV1234"
PASS="OV1234!!"
MEDIA="Application/XML"
NUMBEROFCALLS="10000"
CONCURRENT_CALLS="1"

echo "begin test suite"
runTest "ov-patientSearch" "http://192.168.25.130:7001/MobileHealthPlatformWeb/rest/patients?searchstring=younger" ${USER} ${PASS} ${MEDIA} ${CONCURRENT_CALLS} ${NUMBEROFCALLS}
runTest "ov-allergies" "http://192.168.25.130:7001/MobileHealthPlatformWeb/rest/patient/default/21/allergies" ${USER} ${PASS} ${MEDIA} ${CONCURRENT_CALLS} ${NUMBEROFCALLS}
runTest "ov-problems" "http://192.168.25.130:7001/MobileHealthPlatformWeb/rest/patient/default/21/problems/active" ${USER} ${PASS} ${MEDIA} ${CONCURRENT_CALLS} ${NUMBEROFCALLS}
runTest "ov-activemeds" "http://192.168.25.130:7001/MobileHealthPlatformWeb/rest/patient/default/21/medications/active" ${USER} ${PASS} ${MEDIA} ${CONCURRENT_CALLS} ${NUMBEROFCALLS}
echo "complete with test suite"
