#!/bin/sh

mkdir out

echo fetch using xml format
curl -H "Accept: application/xml" "http://localhost:8080/MobileHealthPlatformWeb/rest/public/health?e" > out/healthy.xml
curl -H "Accept: application/xml" "http://localhost:8080/MobileHealthPlatformWeb/rest/public/health?e&forcefail=true" > out/unhealthy.xml

echo fetch using json format
curl -H "Accept: application/json" "http://localhost:8080/MobileHealthPlatformWeb/rest/public/health?e" > out/healthy.json
curl -H "Accept: application/json" "http://localhost:8080/MobileHealthPlatformWeb/rest/public/health?e&forcefail=true" > out/unhealthy.json

echo fetch using text format
curl -H "Accept: text/plain" "http://localhost:8080/MobileHealthPlatformWeb/rest/public/health?e" > out/healthy.txt
curl -H "Accept: text/plain" "http://localhost:8080/MobileHealthPlatformWeb/rest/public/health?e&forcefail=true" > out/unhealthy.txt

echo fetch using html format
curl -H "Accept: text/html" "http://localhost:8080/MobileHealthPlatformWeb/rest/public/health?e" > out/healthy.html
curl -H "Accept: text/html" "http://localhost:8080/MobileHealthPlatformWeb/rest/public/health?e&forcefail=true" > out/unhealthy.html

echo fetch using HEAD
curl --head "http://localhost:8080/MobileHealthPlatformWeb/rest/public/health?e" > out/healthy.head.txt
curl --head "http://localhost:8080/MobileHealthPlatformWeb/rest/public/health?e&forcefail=true" > out/unhealthy.head.txt

echo complete
