USE [master]
GO

ALTER DATABASE [OIA_ClinicInHand] SET COMPATIBILITY_LEVEL = 100
GO

IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
	begin
		EXEC [OIA_ClinicInHand].[dbo].[sp_fulltext_database] @action = 'enable'
	end
GO

ALTER DATABASE [OIA_ClinicInHand] SET ANSI_NULL_DEFAULT OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET ANSI_NULLS OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET ANSI_PADDING OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET ANSI_WARNINGS OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET ARITHABORT OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET AUTO_CLOSE OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET AUTO_CREATE_STATISTICS ON 
GO

ALTER DATABASE [OIA_ClinicInHand] SET AUTO_SHRINK OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET AUTO_UPDATE_STATISTICS ON 
GO

ALTER DATABASE [OIA_ClinicInHand] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET CURSOR_DEFAULT  GLOBAL 
GO

ALTER DATABASE [OIA_ClinicInHand] SET CONCAT_NULL_YIELDS_NULL OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET NUMERIC_ROUNDABORT OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET QUOTED_IDENTIFIER OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET RECURSIVE_TRIGGERS OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET  DISABLE_BROKER 
GO

ALTER DATABASE [OIA_ClinicInHand] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET TRUSTWORTHY OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET PARAMETERIZATION SIMPLE 
GO

ALTER DATABASE [OIA_ClinicInHand] SET READ_COMMITTED_SNAPSHOT OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET HONOR_BROKER_PRIORITY OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET RECOVERY FULL 
GO

ALTER DATABASE [OIA_ClinicInHand] SET  MULTI_USER 
GO

ALTER DATABASE [OIA_ClinicInHand] SET PAGE_VERIFY CHECKSUM  
GO

ALTER DATABASE [OIA_ClinicInHand] SET DB_CHAINING OFF 
GO

ALTER DATABASE [OIA_ClinicInHand] SET  READ_WRITE 
GO

/* Create OIA_ClinicInHand_APP user */
USE [master]
GO
IF NOT EXISTS 
    (select 1 from master.dbo.syslogins where loginname = 'OIA_ClinicInHand_APP')
BEGIN
	CREATE LOGIN [OIA_ClinicInHand_APP] WITH PASSWORD=N'Agilexadmin99$', 
		DEFAULT_DATABASE=[OIA_ClinicInHand], 
		DEFAULT_LANGUAGE=[us_english], 
		CHECK_EXPIRATION=OFF, 
		CHECK_POLICY=OFF
END
GO
ALTER LOGIN [OIA_ClinicInHand_APP] ENABLE
GO


/* Create App schema */
USE [OIA_ClinicInHand]
GO
IF EXISTS (SELECT 1 FROM sys.schemas WHERE name = 'App')
	DROP SCHEMA App
GO
CREATE SCHEMA App
GO

/* Create liquibase schema */
IF EXISTS (SELECT 1 FROM sys.schemas WHERE name = 'liquibase')
	DROP SCHEMA liquibase
GO
CREATE SCHEMA liquibase
GO
