spool 05_auditing.log
set serveroutput on echo on feedback on

BEGIN
DBMS_AUDIT_MGMT.SET_AUDIT_TRAIL_LOCATION(
	audit_trail_type => DBMS_AUDIT_MGMT.AUDIT_TRAIL_DB_STD,
	audit_trail_location_value =>  'encrypted_auditlog'
);
END;
/
-- Verification
-- Ensure tablespace is set to encrypted_auditlog
select table_name, tablespace_name from dba_tables where table_name in ('AUD$','FGA_LOG$');

-- Creates a session even when login is unsuccessful.
-- Helpful: show parameter audit;
AUDIT CREATE SESSION WHENEVER NOT SUCCESSFUL;

spool off 
